package com.ejianc.business.oa.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 人力行政-证书人员退证申请表
 * 
 * @author generator
 * 
 */
public class CertReturnVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long humanPayId; // 姓名id
    private String humanPayName; // 姓名
    private Integer sex; // 性别 1：男 2：女
    private Long orgId; // 组织ID
    private String orgName; // 组织
    private String idCard; // 身份证号码
    private Long deptId; // 部门ID
    private String deptName; // 部门
    private Long postId; // 岗位ID
    private String postName; // 岗位
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 证书结束时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date insuredBeginDate; // 参保时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date insuredEndDate; // 停保时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date newInsuredEndDate; // 本次停保时间
    private BigDecimal returnMny; // 退费金额
    private String memo; // 退证说明
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "bfyj-cert-human")
    public Long getHumanPayId() {
        return humanPayId;
    }
    @ReferDeserialTransfer
    public void setHumanPayId(Long humanPayId) {
        this.humanPayId = humanPayId;
    }
    public String getHumanPayName() {
        return humanPayName;
    }

    public void setHumanPayName(String humanPayName) {
        this.humanPayName = humanPayName;
    }
    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDeptId() {
        return deptId;
    }
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    @ReferSerialTransfer(referCode="idm_post")
    public Long getPostId() {
        return postId;
    }
    @ReferDeserialTransfer
    public void setPostId(Long postId) {
        this.postId = postId;
    }
    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }
    public Date getInsuredBeginDate() {
        return insuredBeginDate;
    }

    public void setInsuredBeginDate(Date insuredBeginDate) {
        this.insuredBeginDate = insuredBeginDate;
    }
    public Date getInsuredEndDate() {
        return insuredEndDate;
    }

    public void setInsuredEndDate(Date insuredEndDate) {
        this.insuredEndDate = insuredEndDate;
    }
    public Date getNewInsuredEndDate() {
        return newInsuredEndDate;
    }

    public void setNewInsuredEndDate(Date newInsuredEndDate) {
        this.newInsuredEndDate = newInsuredEndDate;
    }
    public BigDecimal getReturnMny() {
        return returnMny;
    }

    public void setReturnMny(BigDecimal returnMny) {
        this.returnMny = returnMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
