package com.ejianc.business.scene.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 现场监控-施工日志
 * 
 * @author generator
 * 
 */
public class IncomeLogVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date logDate; // 施工日期
    private String projectName; // 项目名称
    private String weatherInfo; // 天气信息
    private String logInfo; // 生产情况记录
    private Long projectId; // 项目id
    private Integer photoNum; // 照片数量
    private Integer billState; // 
    private String code; // 
    private Long orgId; // 组织id
    private Long loggerId; // 编制人id
    private String loggerName; // 编制人
    private Integer totalPersonNum; // 作业总人数
    private String materialEnter; // 材料进场情况
    private String existProblem; // 存在问题
    private String memo; // 备注
    

    public Date getLogDate() {
        return logDate;
    }

    public void setLogDate(Date logDate) {
        this.logDate = logDate;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getWeatherInfo() {
        return weatherInfo;
    }

    public void setWeatherInfo(String weatherInfo) {
        this.weatherInfo = weatherInfo;
    }
    public String getLogInfo() {
        return logInfo;
    }

    public void setLogInfo(String logInfo) {
        this.logInfo = logInfo;
    }
    @ReferSerialTransfer(referCode="bfyj-market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public Integer getPhotoNum() {
        return photoNum;
    }

    public void setPhotoNum(Integer photoNum) {
        this.photoNum = photoNum;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getLoggerId() {
        return loggerId;
    }

    @ReferDeserialTransfer
    public void setLoggerId(Long loggerId) {
        this.loggerId = loggerId;
    }
    public String getLoggerName() {
        return loggerName;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }
    public Integer getTotalPersonNum() {
        return totalPersonNum;
    }

    public void setTotalPersonNum(Integer totalPersonNum) {
        this.totalPersonNum = totalPersonNum;
    }
    public String getMaterialEnter() {
        return materialEnter;
    }

    public void setMaterialEnter(String materialEnter) {
        this.materialEnter = materialEnter;
    }
    public String getExistProblem() {
        return existProblem;
    }

    public void setExistProblem(String existProblem) {
        this.existProblem = existProblem;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
