package com.ejianc.business.bid.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 投标管理-确认项目经理及技术负责人
 * 
 * @author generator
 * 
 */
public class ProjectPersonAffirmVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 编码
    private Long registrationId; // 项目报名表Id
    private Long opportunityId; // 商机登记表Id
    private Long opportunityBillCode; // 商机登记单据编码
    private String engineeringName; // 工程名称
    private Long qualificationTypeId; // 资质类别id
    private String qualificationTypeCode; // 资质类别编码
    private String qualificationTypeName; // 资质类别名称
    private Long qualificationLevelId; // 资质等级id
    private String qualificationLevelCode; // 资质等级编码
    private String qualificationLevelName; // 资质等级名称
    private String projectPeriod; // 工期
    private BigDecimal biddingControlMmy; // 控制价(万元)
    private Integer isBidWinning; // 是否中标：0-否，1-是
    private Long documenterId; // 资料员id
    private String documenterName; // 资料员名称
    private String personSocialSecurityDemand; // 人员社保要求
    private String projectManagerDemand; // 项目经理要求
    private String techManagerDemand;//技术负责人要求
    private String projectManagerId; // 项目经理id
    private String projectManagerName; // 项目经理
    private Long employeeId; // 编制人id
    private String employeeName; // 编制人名称
    private String memo; // 备注
    private Integer billState; // 单据状态
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date effectiveDate; // 生效日期
    private String techManagerName; // 技术负责人名称
    private String techManagerId; // 技术负责人id
    private Long orgId; // 所属组织Id
    private String orgCode; // 所属组织编码
    private String orgName; // 所属组织名称
    private String pusherName; // 抄送人
    private String pusherId; // 抄送人
    @ReferSerialTransfer(referCode = "idm-user")
    public String getPusherId() {
        return pusherId;
    }
    @ReferDeserialTransfer
    public void setPusherId(String pusherId) {
        this.pusherId = pusherId;
    }

    public String getPusherName() {
        return pusherName;
    }

    public void setPusherName(String pusherName) {
        this.pusherName = pusherName;
    }

    public String getTechManagerDemand() {
        return techManagerDemand;
    }

    public void setTechManagerDemand(String techManagerDemand) {
        this.techManagerDemand = techManagerDemand;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "bfyj-bid-projectRegistration")
    public Long getRegistrationId() {
        return registrationId;
    }
    @ReferDeserialTransfer
    public void setRegistrationId(Long registrationId) {
        this.registrationId = registrationId;
    }
    @ReferSerialTransfer(referCode = "bfyj-bid-busOpportunity")
    public Long getOpportunityId() {
        return opportunityId;
    }
    @ReferDeserialTransfer
    public void setOpportunityId(Long opportunityId) {
        this.opportunityId = opportunityId;
    }
    public Long getOpportunityBillCode() {
        return opportunityBillCode;
    }

    public void setOpportunityBillCode(Long opportunityBillCode) {
        this.opportunityBillCode = opportunityBillCode;
    }
    public String getEngineeringName() {
        return engineeringName;
    }

    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getQualificationTypeId() {
        return qualificationTypeId;
    }
    @ReferDeserialTransfer
    public void setQualificationTypeId(Long qualificationTypeId) {
        this.qualificationTypeId = qualificationTypeId;
    }
    public String getQualificationTypeCode() {
        return qualificationTypeCode;
    }

    public void setQualificationTypeCode(String qualificationTypeCode) {
        this.qualificationTypeCode = qualificationTypeCode;
    }
    public String getQualificationTypeName() {
        return qualificationTypeName;
    }

    public void setQualificationTypeName(String qualificationTypeName) {
        this.qualificationTypeName = qualificationTypeName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getQualificationLevelId() {
        return qualificationLevelId;
    }
    @ReferDeserialTransfer
    public void setQualificationLevelId(Long qualificationLevelId) {
        this.qualificationLevelId = qualificationLevelId;
    }
    public String getQualificationLevelCode() {
        return qualificationLevelCode;
    }

    public void setQualificationLevelCode(String qualificationLevelCode) {
        this.qualificationLevelCode = qualificationLevelCode;
    }
    public String getQualificationLevelName() {
        return qualificationLevelName;
    }

    public void setQualificationLevelName(String qualificationLevelName) {
        this.qualificationLevelName = qualificationLevelName;
    }
    public String getProjectPeriod() {
        return projectPeriod;
    }

    public void setProjectPeriod(String projectPeriod) {
        this.projectPeriod = projectPeriod;
    }
    public BigDecimal getBiddingControlMmy() {
        return biddingControlMmy;
    }

    public void setBiddingControlMmy(BigDecimal biddingControlMmy) {
        this.biddingControlMmy = biddingControlMmy;
    }
    public Integer getIsBidWinning() {
        return isBidWinning;
    }

    public void setIsBidWinning(Integer isBidWinning) {
        this.isBidWinning = isBidWinning;
    }
    public Long getDocumenterId() {
        return documenterId;
    }

    public void setDocumenterId(Long documenterId) {
        this.documenterId = documenterId;
    }
    public String getDocumenterName() {
        return documenterName;
    }

    public void setDocumenterName(String documenterName) {
        this.documenterName = documenterName;
    }
    public String getPersonSocialSecurityDemand() {
        return personSocialSecurityDemand;
    }

    public void setPersonSocialSecurityDemand(String personSocialSecurityDemand) {
        this.personSocialSecurityDemand = personSocialSecurityDemand;
    }
    public String getProjectManagerDemand() {
        return projectManagerDemand;
    }

    public void setProjectManagerDemand(String projectManagerDemand) {
        this.projectManagerDemand = projectManagerDemand;
    }
    @ReferSerialTransfer(referCode = "bfyj-cert-human")
    public String getProjectManagerId() {
        return projectManagerId;
    }
    @ReferDeserialTransfer
    public void setProjectManagerId(String projectManagerId) {
        this.projectManagerId = projectManagerId;
    }
    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getTechManagerName() {
        return techManagerName;
    }

    public void setTechManagerName(String techManagerName) {
        this.techManagerName = techManagerName;
    }

    @ReferSerialTransfer(referCode = "bfyj-cert-human")
    public String getTechManagerId() {
        return techManagerId;
    }

    @ReferDeserialTransfer
    public void setTechManagerId(String techManagerId) {
        this.techManagerId = techManagerId;
    }
}
