package com.ejianc.business.bid.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 投标管理-开标结果
 * 
 * @author generator
 * 
 */
public class BidOpenResultVO extends BaseVO {
    public static final String OPEN_TYPE_NET = "网开";
    public static final String OPEN_TYPE_SITE = "现场";
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 编码
    private Long registrationId; // 项目报名表Id
    private Long opportunityId; // 商机登记表Id
    private Long opportunityBillCode; // 商机登记单据编码
    private String engineeringName; // 工程名称
    private String memo; // 备注
    private Integer isBidWinning; // 是否中标：0-否，1-是
    private BigDecimal bidMny; // 中标价
    private Long engineeringType; // 工程类型
    private String engineeringTypeName; // 工程类型名称
    private Long projectManagerId; // 项目经理Id
    private String projectManagerName; // 项目经理名称
    private Long techManagerId; // 技术负责人Id
    private String techManagerName; // 技术负责人名称
    private String otherPersonId; // 其他人员Id
    private String otherPersonName; // 其他人员名称
    private String bidOpenType; // 开标类型：网开/现场
    private Integer billState; // 单据状态
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date effectiveDate; // 生效日期
    private Long orgId; // 所属组织id
    private String orgCode; // 所属组织编码
    private String orgName; // 所属组织名称
    private Long employeeId; // 编制人id
    private String employeeName; // 编制人名称

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "bfyj-bid-projectRegistration")
    public Long getRegistrationId() {
        return registrationId;
    }
    @ReferDeserialTransfer
    public void setRegistrationId(Long registrationId) {
        this.registrationId = registrationId;
    }
    @ReferSerialTransfer(referCode = "bfyj-bid-busOpportunity")
    public Long getOpportunityId() {
        return opportunityId;
    }
    @ReferDeserialTransfer
    public void setOpportunityId(Long opportunityId) {
        this.opportunityId = opportunityId;
    }
    public Long getOpportunityBillCode() {
        return opportunityBillCode;
    }

    public void setOpportunityBillCode(Long opportunityBillCode) {
        this.opportunityBillCode = opportunityBillCode;
    }
    public String getEngineeringName() {
        return engineeringName;
    }

    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getIsBidWinning() {
        return isBidWinning;
    }

    public void setIsBidWinning(Integer isBidWinning) {
        this.isBidWinning = isBidWinning;
    }
    public BigDecimal getBidMny() {
        return bidMny;
    }

    public void setBidMny(BigDecimal bidMny) {
        this.bidMny = bidMny;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getEngineeringType() {
        return engineeringType;
    }
    @ReferDeserialTransfer
    public void setEngineeringType(Long engineeringType) {
        this.engineeringType = engineeringType;
    }
    public String getEngineeringTypeName() {
        return engineeringTypeName;
    }

    public void setEngineeringTypeName(String engineeringTypeName) {
        this.engineeringTypeName = engineeringTypeName;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getProjectManagerId() {
        return projectManagerId;
    }
    @ReferDeserialTransfer
    public void setProjectManagerId(Long projectManagerId) {
        this.projectManagerId = projectManagerId;
    }
    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getTechManagerId() {
        return techManagerId;
    }
    @ReferDeserialTransfer
    public void setTechManagerId(Long techManagerId) {
        this.techManagerId = techManagerId;
    }
    public String getTechManagerName() {
        return techManagerName;
    }

    public void setTechManagerName(String techManagerName) {
        this.techManagerName = techManagerName;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public String getOtherPersonId() {
        return otherPersonId;
    }
    @ReferDeserialTransfer
    public void setOtherPersonId(String otherPersonId) {
        this.otherPersonId = otherPersonId;
    }
    public String getOtherPersonName() {
        return otherPersonName;
    }

    public void setOtherPersonName(String otherPersonName) {
        this.otherPersonName = otherPersonName;
    }
    public String getBidOpenType() {
        return bidOpenType;
    }

    public void setBidOpenType(String bidOpenType) {
        this.bidOpenType = bidOpenType;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    
}
