package com.ejianc.business.tax.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 税务管理-收票登记-详情
 * 
 * @author generator
 * 
 */
public class InvoiceReceivePoolVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String projectName; // 项目名称
    private Long projectId; // 项目主键
    private String orgName; // 组织名称
    private Long orgId; // 组织主键
    private String orgCode; // 组织编码
    private Long parentOrgId; // 项目所属组织
    private String parentOrgName; // 项目所属组织名称
    private String parentOrgCode; // 项目所属组织编码
    private Integer receiveType; // 业务类型：1自缴异地预缴2/项目异地预缴票
//    private Long customerId; // 购方主键
//    private String customerName; // 购方名称
    private String supplierName; // 供应商名称
    private Long supplierId; // 供应商主键
    private String memo; // 备注
    private Long invoiceType; // 发票类型
    private String invoiceTypeName; // 发票类型名称；
    private String invoiceNumber; // 发票号码
    private String invoiceCode; // 发票代码
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date invoiceDate; // 开票日期
    private BigDecimal invoiceMny; // 发票金额（不含税）
    private BigDecimal taxMny; // 税额
    private BigDecimal invoiceTaxMny; // 价税合计
    private String billCode; // 主表编码
    private Integer billState; // 单据状态（审批必须字段）
    private String employeeName; // 经办人名称
    private Long employeeId; // 经办人
    private String invoiceTaxMnys; // 价税合计大写
    private String receiveBillCode; // 收票登记单号
    private Long receiveBillId; // 收票登记单id
    private Integer regist; // 是否登记
    private BigDecimal taxRate; // 税率
    private Integer passFlag; // 是否合格(1-是，0否)
    private String receiveTypeName; // 业务类型：1自缴异地预缴2/项目异地预缴票


    private String passFlagName; // 是否合格(1-是，0否)
    private Long projectBillId; //项目对账单id（台账查询时用）
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date useDate; //使用日期

    public String getPassFlagName() {
        return passFlagName;
    }

    public void setPassFlagName(String passFlagName) {
        this.passFlagName = passFlagName;
    }

    public Long getProjectBillId() {
        return projectBillId;
    }

    public void setProjectBillId(Long projectBillId) {
        this.projectBillId = projectBillId;
    }

    public Date getUseDate() {
        return useDate;
    }

    public void setUseDate(Date useDate) {
        this.useDate = useDate;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="bfyj-market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getOrgName() {
        return orgName;
    }

    public Integer getPassFlag() {
        return passFlag;
    }

    public void setPassFlag(Integer passFlag) {
        this.passFlag = passFlag;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public String getReceiveTypeName() {
        return receiveTypeName;
    }

    public void setReceiveTypeName(String receiveTypeName) {
        this.receiveTypeName = receiveTypeName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Integer getReceiveType() {
        return receiveType;
    }

    public void setReceiveType(Integer receiveType) {
        this.receiveType = receiveType;
    }
//    @ReferSerialTransfer(referCode="support-customer")
//    public Long getCustomerId() {
//        return customerId;
//    }
//    @ReferDeserialTransfer
//    public void setCustomerId(Long customerId) {
//        this.customerId = customerId;
//    }
//    public String getCustomerName() {
//        return customerName;
//    }
//
//    public void setCustomerName(String customerName) {
//        this.customerName = customerName;
//    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    @ReferSerialTransfer(referCode="support-customer")
    public Long getSupplierId() {
        return supplierId;
    }
    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getInvoiceType() {
        return invoiceType;
    }
    @ReferDeserialTransfer
    public void setInvoiceType(Long invoiceType) {
        this.invoiceType = invoiceType;
    }
    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }
    public String getInvoiceNumber() {
        return invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }
    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }
    public Date getInvoiceDate() {
        return invoiceDate;
    }

    public void setInvoiceDate(Date invoiceDate) {
        this.invoiceDate = invoiceDate;
    }
    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getInvoiceTaxMny() {
        return invoiceTaxMny;
    }

    public void setInvoiceTaxMny(BigDecimal invoiceTaxMny) {
        this.invoiceTaxMny = invoiceTaxMny;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getInvoiceTaxMnys() {
        return invoiceTaxMnys;
    }

    public void setInvoiceTaxMnys(String invoiceTaxMnys) {
        this.invoiceTaxMnys = invoiceTaxMnys;
    }
    public String getReceiveBillCode() {
        return receiveBillCode;
    }

    public void setReceiveBillCode(String receiveBillCode) {
        this.receiveBillCode = receiveBillCode;
    }
    public Long getReceiveBillId() {
        return receiveBillId;
    }

    public void setReceiveBillId(Long receiveBillId) {
        this.receiveBillId = receiveBillId;
    }
    public Integer getRegist() {
        return regist;
    }

    public void setRegist(Integer regist) {
        this.regist = regist;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    
}
