package com.ejianc.business.invest.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 项目投资-个人还款
 * 
 * @author generator
 * 
 */
public class PersonRepaymentVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 项目所属组织
    private String parentOrgCode; // 项目所属组织编码
    private String parentOrgName; // 项目所属组织名称
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long personDebtId; // 借款单id
    private String personDebtCode; // 借款单编码
    private Long debtPersonId; // 借款人
    private String debtPersonName; // 借款人名称
    private String idCard; // 借款人身份证号
    private BigDecimal repaymentMny; // 还款金额
    private String repaymentMnyStr; // 还款金额大写
    private BigDecimal repaymentCapitalMny; // 还款本金
    private BigDecimal repaymentInterestMny; // 还款利息
    private BigDecimal totalInterestMny; // 已还利息（不含本次）
    private String interestType; // 计息方式：取第一次项目借款单计息方式
    private BigDecimal interestRate; // 利率 取第一次项目借款单利率
    private String interestRateMonth; // 利率（按月计息），下拉选则，1-1分，2-2分，3-3分，即每月1%，2%，3%利息。
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date interestStartDate; // 利息开始日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date handleDate; // 办理日期
    private BigDecimal totalDebtMny; // 累计借款金额（本项目累计借款金额合计）
    private BigDecimal totalRepaymentMny; // 累计还款金额（本项目累计还款金额合计）
    private BigDecimal totalDebtResidueMny; // 累计借款结余（累计借款本金-累计还款本金）
    private Long accountId; // 收款账户
    private String accountName; // 账户名
    private String memo; // 备注
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime; // 经办时间

    private String billStateName; // 单据状态名称

    private BigDecimal allInterestMny; // 利息总额
    private BigDecimal remainInterestMny; // 剩余利息
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date lastHandleDate; // 上次办理日期
    private BigDecimal lastAllInterestMny; // 上次利息总额


    //借款单维度金额
    private BigDecimal billDebtMny; // 借款金额
    private BigDecimal billRepaymentMny; // 还款金额
    private BigDecimal billDebtResidueMny; // 借款结余（累计借款本金-累计还款本金）
    private BigDecimal billLastRepaymentMny; // 上次总还款金额

    public BigDecimal getLastAllInterestMny() {
        return lastAllInterestMny;
    }

    public void setLastAllInterestMny(BigDecimal lastAllInterestMny) {
        this.lastAllInterestMny = lastAllInterestMny;
    }

    public BigDecimal getBillLastRepaymentMny() {
        return billLastRepaymentMny;
    }

    public void setBillLastRepaymentMny(BigDecimal billLastRepaymentMny) {
        this.billLastRepaymentMny = billLastRepaymentMny;
    }

    public BigDecimal getBillDebtMny() {
        return billDebtMny;
    }

    public void setBillDebtMny(BigDecimal billDebtMny) {
        this.billDebtMny = billDebtMny;
    }

    public BigDecimal getBillRepaymentMny() {
        return billRepaymentMny;
    }

    public void setBillRepaymentMny(BigDecimal billRepaymentMny) {
        this.billRepaymentMny = billRepaymentMny;
    }

    public BigDecimal getBillDebtResidueMny() {
        return billDebtResidueMny;
    }

    public void setBillDebtResidueMny(BigDecimal billDebtResidueMny) {
        this.billDebtResidueMny = billDebtResidueMny;
    }
    public BigDecimal getAllInterestMny() {
        return allInterestMny;
    }

    public void setAllInterestMny(BigDecimal allInterestMny) {
        this.allInterestMny = allInterestMny;
    }

    public BigDecimal getRemainInterestMny() {
        return remainInterestMny;
    }

    public void setRemainInterestMny(BigDecimal remainInterestMny) {
        this.remainInterestMny = remainInterestMny;
    }

    public Date getLastHandleDate() {
        return lastHandleDate;
    }

    public void setLastHandleDate(Date lastHandleDate) {
        this.lastHandleDate = lastHandleDate;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode = "person-debt")
    public Long getPersonDebtId() {
        return personDebtId;
    }

    @ReferDeserialTransfer
    public void setPersonDebtId(Long personDebtId) {
        this.personDebtId = personDebtId;
    }
    public String getPersonDebtCode() {
        return personDebtCode;
    }

    public void setPersonDebtCode(String personDebtCode) {
        this.personDebtCode = personDebtCode;
    }
    public Long getDebtPersonId() {
        return debtPersonId;
    }

    public void setDebtPersonId(Long debtPersonId) {
        this.debtPersonId = debtPersonId;
    }
    public String getDebtPersonName() {
        return debtPersonName;
    }

    public void setDebtPersonName(String debtPersonName) {
        this.debtPersonName = debtPersonName;
    }
    public BigDecimal getRepaymentMny() {
        return repaymentMny;
    }

    public void setRepaymentMny(BigDecimal repaymentMny) {
        this.repaymentMny = repaymentMny;
    }
    public String getRepaymentMnyStr() {
        return repaymentMnyStr;
    }

    public void setRepaymentMnyStr(String repaymentMnyStr) {
        this.repaymentMnyStr = repaymentMnyStr;
    }
    public BigDecimal getRepaymentCapitalMny() {
        return repaymentCapitalMny;
    }

    public void setRepaymentCapitalMny(BigDecimal repaymentCapitalMny) {
        this.repaymentCapitalMny = repaymentCapitalMny;
    }
    public BigDecimal getRepaymentInterestMny() {
        return repaymentInterestMny;
    }

    public void setRepaymentInterestMny(BigDecimal repaymentInterestMny) {
        this.repaymentInterestMny = repaymentInterestMny;
    }
    public BigDecimal getTotalInterestMny() {
        return totalInterestMny;
    }

    public void setTotalInterestMny(BigDecimal totalInterestMny) {
        this.totalInterestMny = totalInterestMny;
    }
    public String getInterestType() {
        return interestType;
    }

    public void setInterestType(String interestType) {
        this.interestType = interestType;
    }
    public BigDecimal getInterestRate() {
        return interestRate;
    }

    public void setInterestRate(BigDecimal interestRate) {
        this.interestRate = interestRate;
    }
    public String getInterestRateMonth() {
        return interestRateMonth;
    }

    public void setInterestRateMonth(String interestRateMonth) {
        this.interestRateMonth = interestRateMonth;
    }
    public Date getInterestStartDate() {
        return interestStartDate;
    }

    public void setInterestStartDate(Date interestStartDate) {
        this.interestStartDate = interestStartDate;
    }
    public Date getHandleDate() {
        return handleDate;
    }

    public void setHandleDate(Date handleDate) {
        this.handleDate = handleDate;
    }
    public BigDecimal getTotalDebtMny() {
        return totalDebtMny;
    }

    public void setTotalDebtMny(BigDecimal totalDebtMny) {
        this.totalDebtMny = totalDebtMny;
    }
    public BigDecimal getTotalRepaymentMny() {
        return totalRepaymentMny;
    }

    public void setTotalRepaymentMny(BigDecimal totalRepaymentMny) {
        this.totalRepaymentMny = totalRepaymentMny;
    }
    public BigDecimal getTotalDebtResidueMny() {
        return totalDebtResidueMny;
    }

    public void setTotalDebtResidueMny(BigDecimal totalDebtResidueMny) {
        this.totalDebtResidueMny = totalDebtResidueMny;
    }
    @ReferSerialTransfer(referCode = "bfyj-account-register")
    public Long getAccountId() {
        return accountId;
    }

    @ReferDeserialTransfer
    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
}
