package com.ejianc.business.oa.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 人力行政-人力需求申请表
 * 
 * @author generator
 * 
 */
public class HumanRequireVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 单据编号
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long applyDeptId; // 申请部门id
    private String applyDeptName; // 申请部门
    private Long applyPostId; // 申请岗位id
    private String applyPostName; // 申请岗位
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate; // 申请日期
    private Integer applyNum; // 申请人数
    private Integer nowNum; // 现有人数
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date hopeDate; // 期望到岗日期
    private Integer humanType; // 人员类别1:补充新人2：替换现任职员
    private String humanTypeName; // 人员类别1:补充新人2：替换现任职员
    private Integer jobType; // 用工形式1:正式员工2：临时员工
    private String jobTypeName; // 用工形式1:正式员工2：临时员工
    private Integer requireType; // 人力需求1:从公司外部招聘 2：从公司内部调配
    private String requireTypeName; // 人力需求1:从公司外部招聘 2：从公司内部调配
    private String memo; // 招聘岗位主要职责
    private String remark; // 招聘岗位任职资格
    

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getApplyDeptId() {
        return applyDeptId;
    }
    @ReferDeserialTransfer
    public void setApplyDeptId(Long applyDeptId) {
        this.applyDeptId = applyDeptId;
    }
    public String getApplyDeptName() {
        return applyDeptName;
    }

    public void setApplyDeptName(String applyDeptName) {
        this.applyDeptName = applyDeptName;
    }
    @ReferSerialTransfer(referCode="idm_post")
    public Long getApplyPostId() {
        return applyPostId;
    }
    @ReferDeserialTransfer
    public void setApplyPostId(Long applyPostId) {
        this.applyPostId = applyPostId;
    }
    public String getApplyPostName() {
        return applyPostName;
    }

    public void setApplyPostName(String applyPostName) {
        this.applyPostName = applyPostName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    public Integer getApplyNum() {
        return applyNum;
    }

    public void setApplyNum(Integer applyNum) {
        this.applyNum = applyNum;
    }
    public Integer getNowNum() {
        return nowNum;
    }

    public void setNowNum(Integer nowNum) {
        this.nowNum = nowNum;
    }
    public Date getHopeDate() {
        return hopeDate;
    }

    public void setHopeDate(Date hopeDate) {
        this.hopeDate = hopeDate;
    }
    public Integer getHumanType() {
        return humanType;
    }

    public void setHumanType(Integer humanType) {
        this.humanType = humanType;
    }
    public String getHumanTypeName() {
        return humanTypeName;
    }

    public void setHumanTypeName(String humanTypeName) {
        this.humanTypeName = humanTypeName;
    }
    public Integer getJobType() {
        return jobType;
    }

    public void setJobType(Integer jobType) {
        this.jobType = jobType;
    }
    public String getJobTypeName() {
        return jobTypeName;
    }

    public void setJobTypeName(String jobTypeName) {
        this.jobTypeName = jobTypeName;
    }
    public Integer getRequireType() {
        return requireType;
    }

    public void setRequireType(Integer requireType) {
        this.requireType = requireType;
    }
    public String getRequireTypeName() {
        return requireTypeName;
    }

    public void setRequireTypeName(String requireTypeName) {
        this.requireTypeName = requireTypeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    
}
