package com.ejianc.business.bid.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;

/**
 * 公司业绩台账用vo
 * @author CJ
 * @Description:
 * @date 2024/11/13 18:05
 */
public class CompanyPerformanceVO extends BaseVO {

    private static final long serialVersionUID = -1828289620076669848L;

    private String code; // 项目编号
    private String name; // 项目名称
    private Long projectManager; // 项目经理
    private Long techManager; // 技术负责人/总工
    private BigDecimal bidMny; // 合同金额（万元）
    private BigDecimal duration; // 计划工期
    private String winningBidFileName; //中标通知书
    private String winningBidFileId; //中标通知书
    private String contractFileName; //合同
    private String contractFileId; //合同
    private String checkFileName; //竣工验收
    private String checkFileId; //竣工验收
    private String changeFileName; //变更
    private String changeFileId; //变更
    private String workScope; //工程范围
    private String contractualModelName; //业绩类型
    private String contractorUnitName; //建设单位名称
    private Long projectAccountingId; //项目会计
    private Long followPersonId; //业务经理
    private Long contractBillId;
    private Long checkFillBillId;
    private Long winningBidBillId;
    private Long changeFileBillId;
    private Integer winningBidFileNum;
    private Integer contractFileNum;
    private Integer checkFileNum;
    private Integer changeFileNum;
    private String fourNet; //四库网查
    private String provinceNet; //省平台网查
    private String roadNet; //全国公路网查
    private String bidAnnounce; //中标公示

    public String getFourNet() {
        return fourNet;
    }

    public void setFourNet(String fourNet) {
        this.fourNet = fourNet;
    }

    public String getProvinceNet() {
        return provinceNet;
    }

    public void setProvinceNet(String provinceNet) {
        this.provinceNet = provinceNet;
    }

    public String getRoadNet() {
        return roadNet;
    }

    public void setRoadNet(String roadNet) {
        this.roadNet = roadNet;
    }

    public String getBidAnnounce() {
        return bidAnnounce;
    }

    public void setBidAnnounce(String bidAnnounce) {
        this.bidAnnounce = bidAnnounce;
    }

    public Integer getWinningBidFileNum() {
        return winningBidFileNum;
    }

    public void setWinningBidFileNum(Integer winningBidFileNum) {
        this.winningBidFileNum = winningBidFileNum;
    }

    public Integer getContractFileNum() {
        return contractFileNum;
    }

    public void setContractFileNum(Integer contractFileNum) {
        this.contractFileNum = contractFileNum;
    }

    public Integer getCheckFileNum() {
        return checkFileNum;
    }

    public void setCheckFileNum(Integer checkFileNum) {
        this.checkFileNum = checkFileNum;
    }

    public Integer getChangeFileNum() {
        return changeFileNum;
    }

    public void setChangeFileNum(Integer changeFileNum) {
        this.changeFileNum = changeFileNum;
    }

    public Long getContractBillId() {
        return contractBillId;
    }

    public void setContractBillId(Long contractBillId) {
        this.contractBillId = contractBillId;
    }

    public Long getCheckFillBillId() {
        return checkFillBillId;
    }

    public void setCheckFillBillId(Long checkFillBillId) {
        this.checkFillBillId = checkFillBillId;
    }

    public Long getWinningBidBillId() {
        return winningBidBillId;
    }

    public void setWinningBidBillId(Long winningBidBillId) {
        this.winningBidBillId = winningBidBillId;
    }

    public Long getChangeFileBillId() {
        return changeFileBillId;
    }

    public void setChangeFileBillId(Long changeFileBillId) {
        this.changeFileBillId = changeFileBillId;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ReferSerialTransfer(referCode = "cert-record")
    public Long getProjectManager() {
        return projectManager;
    }
    @ReferDeserialTransfer
    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }
    @ReferSerialTransfer(referCode = "cert-record")
    public Long getTechManager() {
        return techManager;
    }
    @ReferDeserialTransfer
    public void setTechManager(Long techManager) {
        this.techManager = techManager;
    }

    public BigDecimal getBidMny() {
        return bidMny;
    }

    public void setBidMny(BigDecimal bidMny) {
        this.bidMny = bidMny;
    }

    public BigDecimal getDuration() {
        return duration;
    }

    public void setDuration(BigDecimal duration) {
        this.duration = duration;
    }

    public String getWinningBidFileName() {
        return winningBidFileName;
    }

    public void setWinningBidFileName(String winningBidFileName) {
        this.winningBidFileName = winningBidFileName;
    }

    public String getWinningBidFileId() {
        return winningBidFileId;
    }

    public void setWinningBidFileId(String winningBidFileId) {
        this.winningBidFileId = winningBidFileId;
    }

    public String getContractFileName() {
        return contractFileName;
    }

    public void setContractFileName(String contractFileName) {
        this.contractFileName = contractFileName;
    }

    public String getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(String contractFileId) {
        this.contractFileId = contractFileId;
    }

    public String getCheckFileName() {
        return checkFileName;
    }

    public void setCheckFileName(String checkFileName) {
        this.checkFileName = checkFileName;
    }

    public String getCheckFileId() {
        return checkFileId;
    }

    public void setCheckFileId(String checkFileId) {
        this.checkFileId = checkFileId;
    }

    public String getChangeFileName() {
        return changeFileName;
    }

    public void setChangeFileName(String changeFileName) {
        this.changeFileName = changeFileName;
    }

    public String getChangeFileId() {
        return changeFileId;
    }

    public void setChangeFileId(String changeFileId) {
        this.changeFileId = changeFileId;
    }

    public String getWorkScope() {
        return workScope;
    }

    public void setWorkScope(String workScope) {
        this.workScope = workScope;
    }

    public String getContractualModelName() {
        return contractualModelName;
    }

    public void setContractualModelName(String contractualModelName) {
        this.contractualModelName = contractualModelName;
    }

    public String getContractorUnitName() {
        return contractorUnitName;
    }

    public void setContractorUnitName(String contractorUnitName) {
        this.contractorUnitName = contractorUnitName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getProjectAccountingId() {
        return projectAccountingId;
    }
    @ReferDeserialTransfer
    public void setProjectAccountingId(Long projectAccountingId) {
        this.projectAccountingId = projectAccountingId;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getFollowPersonId() {
        return followPersonId;
    }
    @ReferDeserialTransfer
    public void setFollowPersonId(Long followPersonId) {
        this.followPersonId = followPersonId;
    }
}
