package com.ejianc.business.tax.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 税务管理-开票申请
 * 
 * @author generator
 * 
 */
public class InvoiceOpenApplyVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String code; // 申请单号
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date beginDate; // 合同开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishDate; // 合同竣工日期
    private BigDecimal bidMny; // 中标金额
    private String projectProgress; // 工程进度(%)
    private String orgName; // 
    private Long orgId; // 组织id
    private String orgCode; // 组织编码
    private Long parentOrgId; // 项目所属组织
    private String parentOrgName; // 项目所属组织名称
    private String parentOrgCode; // 项目所属组织编码
    private Long invoiceBases; // 开票依据
    private String invoiceBasesName; // 开票依据
    private Long invoiceType; // 发票类型
    private String invoiceTypeName; // 发票类型
    private Long taxType; // 计税方式
    private String taxTypeName; // 计税方式
    private Long buyerId; // 购方id（客户档案）
    private String buyerName; // 购方名称
    private String buyerTaxId; // 购方纳税人识别号
    private String buyerBankAccount; // 购方开户银行及账号
    private String buyerAddrPhone; // 购方地址及电话
    private String invoiceInfo; // 发票内容
    private BigDecimal applyMny; // 申请金额（不含税）
    private BigDecimal applyMnyTax; // 申请金额 含税
    private BigDecimal taxRate; // 税率
    private String applyMnyTaxChn; // 申请金额 含税大写
    private BigDecimal tax; // 税金
    private Long applyerId; // 申请人id
    private String applyerName; // 申请人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate; // 申请日期
    private String memo; // 备注
    private Integer openType; // 0--未开票 1--已开票
    private String addr; // 建筑服务发生地

    public String getAddr() {
        return addr;
    }

    public void setAddr(String addr) {
        this.addr = addr;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    @ReferSerialTransfer(referCode="bfyj-market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }
    public Date getFinishDate() {
        return finishDate;
    }

    public void setFinishDate(Date finishDate) {
        this.finishDate = finishDate;
    }
    public BigDecimal getBidMny() {
        return bidMny;
    }

    public void setBidMny(BigDecimal bidMny) {
        this.bidMny = bidMny;
    }
    public String getProjectProgress() {
        return projectProgress;
    }

    public void setProjectProgress(String projectProgress) {
        this.projectProgress = projectProgress;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getInvoiceBases() {
        return invoiceBases;
    }
    @ReferDeserialTransfer
    public void setInvoiceBases(Long invoiceBases) {
        this.invoiceBases = invoiceBases;
    }
    public String getInvoiceBasesName() {
        return invoiceBasesName;
    }

    public void setInvoiceBasesName(String invoiceBasesName) {
        this.invoiceBasesName = invoiceBasesName;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getInvoiceType() {
        return invoiceType;
    }
    @ReferDeserialTransfer
    public void setInvoiceType(Long invoiceType) {
        this.invoiceType = invoiceType;
    }
    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }
    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getTaxType() {
        return taxType;
    }
    @ReferDeserialTransfer
    public void setTaxType(Long taxType) {
        this.taxType = taxType;
    }
    public String getTaxTypeName() {
        return taxTypeName;
    }

    public void setTaxTypeName(String taxTypeName) {
        this.taxTypeName = taxTypeName;
    }
    @ReferSerialTransfer(referCode="support-customer")
    public Long getBuyerId() {
        return buyerId;
    }
    @ReferDeserialTransfer
    public void setBuyerId(Long buyerId) {
        this.buyerId = buyerId;
    }
    public String getBuyerName() {
        return buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }
    public String getBuyerTaxId() {
        return buyerTaxId;
    }

    public void setBuyerTaxId(String buyerTaxId) {
        this.buyerTaxId = buyerTaxId;
    }
    public String getBuyerBankAccount() {
        return buyerBankAccount;
    }

    public void setBuyerBankAccount(String buyerBankAccount) {
        this.buyerBankAccount = buyerBankAccount;
    }
    public String getBuyerAddrPhone() {
        return buyerAddrPhone;
    }

    public void setBuyerAddrPhone(String buyerAddrPhone) {
        this.buyerAddrPhone = buyerAddrPhone;
    }
    public String getInvoiceInfo() {
        return invoiceInfo;
    }

    public void setInvoiceInfo(String invoiceInfo) {
        this.invoiceInfo = invoiceInfo;
    }
    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    public BigDecimal getApplyMnyTax() {
        return applyMnyTax;
    }

    public void setApplyMnyTax(BigDecimal applyMnyTax) {
        this.applyMnyTax = applyMnyTax;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public String getApplyMnyTaxChn() {
        return applyMnyTaxChn;
    }

    public void setApplyMnyTaxChn(String applyMnyTaxChn) {
        this.applyMnyTaxChn = applyMnyTaxChn;
    }
    public BigDecimal getTax() {
        return tax;
    }

    public void setTax(BigDecimal tax) {
        this.tax = tax;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getApplyerId() {
        return applyerId;
    }
    @ReferDeserialTransfer
    public void setApplyerId(Long applyerId) {
        this.applyerId = applyerId;
    }
    public String getApplyerName() {
        return applyerName;
    }

    public void setApplyerName(String applyerName) {
        this.applyerName = applyerName;
    }
    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getOpenType() {
        return openType;
    }

    public void setOpenType(Integer openType) {
        this.openType = openType;
    }
    
}
