package com.ejianc.business.cost.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 成本会计-办事处会员明细
 * 
 * @author generator
 * 
 */
public class OfficeMemberVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 项目所属组织
    private String parentOrgCode; // 项目所属组织编码
    private String parentOrgName; // 项目所属组织名称
    private String name; // 名称
    private String handlePerson; // 负责人
    private String phone; // 电话
    private Long businessManagerId; // 业务经理
    private String businessManagerName; // 业务经理名称
    private Long documentPersonId; // 资料员
    private String documentPersonName; // 资料员
    private BigDecimal yearMny; // 年薪
    private String cooperationTerm; // 合作期限
    private BigDecimal outputLimit; // 产值额度
    private BigDecimal managementFeePoint; // 管理费收取点数
    private BigDecimal managerPointRate; // 业务经理返点比例
    private String memo; // 备注
    private String cooperationBidNum; // 合作期间中标数量
    private BigDecimal cooperationBidOutputMny; // 合作期间中标总产值
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date bidDate; // 中标日期
    private BigDecimal bidMny; // 中标金额
    private String bidProjectName; // 中标项目名称
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime; // 经办时间


    private String billStateName; // 单据状态名称
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getHandlePerson() {
        return handlePerson;
    }

    public void setHandlePerson(String handlePerson) {
        this.handlePerson = handlePerson;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getBusinessManagerId() {
        return businessManagerId;
    }

    @ReferDeserialTransfer
    public void setBusinessManagerId(Long businessManagerId) {
        this.businessManagerId = businessManagerId;
    }
    public String getBusinessManagerName() {
        return businessManagerName;
    }

    public void setBusinessManagerName(String businessManagerName) {
        this.businessManagerName = businessManagerName;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getDocumentPersonId() {
        return documentPersonId;
    }

    @ReferDeserialTransfer
    public void setDocumentPersonId(Long documentPersonId) {
        this.documentPersonId = documentPersonId;
    }
    public String getDocumentPersonName() {
        return documentPersonName;
    }

    public void setDocumentPersonName(String documentPersonName) {
        this.documentPersonName = documentPersonName;
    }
    public BigDecimal getYearMny() {
        return yearMny;
    }

    public void setYearMny(BigDecimal yearMny) {
        this.yearMny = yearMny;
    }
    public String getCooperationTerm() {
        return cooperationTerm;
    }

    public void setCooperationTerm(String cooperationTerm) {
        this.cooperationTerm = cooperationTerm;
    }
    public BigDecimal getOutputLimit() {
        return outputLimit;
    }

    public void setOutputLimit(BigDecimal outputLimit) {
        this.outputLimit = outputLimit;
    }
    public BigDecimal getManagementFeePoint() {
        return managementFeePoint;
    }

    public void setManagementFeePoint(BigDecimal managementFeePoint) {
        this.managementFeePoint = managementFeePoint;
    }
    public BigDecimal getManagerPointRate() {
        return managerPointRate;
    }

    public void setManagerPointRate(BigDecimal managerPointRate) {
        this.managerPointRate = managerPointRate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getCooperationBidNum() {
        return cooperationBidNum;
    }

    public void setCooperationBidNum(String cooperationBidNum) {
        this.cooperationBidNum = cooperationBidNum;
    }
    public BigDecimal getCooperationBidOutputMny() {
        return cooperationBidOutputMny;
    }

    public void setCooperationBidOutputMny(BigDecimal cooperationBidOutputMny) {
        this.cooperationBidOutputMny = cooperationBidOutputMny;
    }
    public Date getBidDate() {
        return bidDate;
    }

    public void setBidDate(Date bidDate) {
        this.bidDate = bidDate;
    }
    public BigDecimal getBidMny() {
        return bidMny;
    }

    public void setBidMny(BigDecimal bidMny) {
        this.bidMny = bidMny;
    }
    public String getBidProjectName() {
        return bidProjectName;
    }

    public void setBidProjectName(String bidProjectName) {
        this.bidProjectName = bidProjectName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
}
