package com.ejianc.business.asset.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 资产管理-项目尽调
 * 
 * @author generator
 * 
 */
public class ProjectCheckVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 上级组织
    private String parentOrgCode; // 上级组织编码
    private String parentOrgName; // 上级组织名称
    private String projectName; // 项目名称
    private String businessSource; // 业务来源
    private Long chargePersonId; // 跟踪负责人
    private String chargePersonName; // 跟踪负责人名称
    private String checkCycle; // 尽调周期
    private String bottomPropertyPosition; // 底层资产位置
    private String propertyType; // 资产类别
    private String area; // 面积
    private String debtPerson; // 债务人
    private String claimPerson; // 债权人
    private String claimTarget; // 债券标的
    private String mortgageCloseSituation; // 抵押及查封情况
    private String investConsideration; // 拟投资对价
    private Integer assetAllocationFlag; // 是否配资(1:是，0：否)
    private String actualInvestQuota; // 我方实际投资额
    private String investCycle; // 投资周期
    private String predictCashPayment; // 预期变现回款
    private String taxCostPredict; // 税费成本预估
    private String otherFeePredict; // 其他费用预估
    private String financeCostPredict; // 财务成本预估
    private String profitPredict; // 净利润预估
    private String profitRatePredict; // 利润率预估
    private String yearProfitRatePredict; // 年化平均利润率预估
    private Integer submitReportFlag; // 是否提交尽调报告(1:是，0：否)
    private String memo; // 备注
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime; // 经办时间

    private String billStateName;

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getBusinessSource() {
        return businessSource;
    }

    public void setBusinessSource(String businessSource) {
        this.businessSource = businessSource;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getChargePersonId() {
        return chargePersonId;
    }

    @ReferDeserialTransfer
    public void setChargePersonId(Long chargePersonId) {
        this.chargePersonId = chargePersonId;
    }
    public String getChargePersonName() {
        return chargePersonName;
    }

    public void setChargePersonName(String chargePersonName) {
        this.chargePersonName = chargePersonName;
    }
    public String getCheckCycle() {
        return checkCycle;
    }

    public void setCheckCycle(String checkCycle) {
        this.checkCycle = checkCycle;
    }
    public String getBottomPropertyPosition() {
        return bottomPropertyPosition;
    }

    public void setBottomPropertyPosition(String bottomPropertyPosition) {
        this.bottomPropertyPosition = bottomPropertyPosition;
    }
    public String getPropertyType() {
        return propertyType;
    }

    public void setPropertyType(String propertyType) {
        this.propertyType = propertyType;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public String getDebtPerson() {
        return debtPerson;
    }

    public void setDebtPerson(String debtPerson) {
        this.debtPerson = debtPerson;
    }
    public String getClaimPerson() {
        return claimPerson;
    }

    public void setClaimPerson(String claimPerson) {
        this.claimPerson = claimPerson;
    }
    public String getClaimTarget() {
        return claimTarget;
    }

    public void setClaimTarget(String claimTarget) {
        this.claimTarget = claimTarget;
    }
    public String getMortgageCloseSituation() {
        return mortgageCloseSituation;
    }

    public void setMortgageCloseSituation(String mortgageCloseSituation) {
        this.mortgageCloseSituation = mortgageCloseSituation;
    }
    public String getInvestConsideration() {
        return investConsideration;
    }

    public void setInvestConsideration(String investConsideration) {
        this.investConsideration = investConsideration;
    }
    public Integer getAssetAllocationFlag() {
        return assetAllocationFlag;
    }

    public void setAssetAllocationFlag(Integer assetAllocationFlag) {
        this.assetAllocationFlag = assetAllocationFlag;
    }
    public String getActualInvestQuota() {
        return actualInvestQuota;
    }

    public void setActualInvestQuota(String actualInvestQuota) {
        this.actualInvestQuota = actualInvestQuota;
    }
    public String getInvestCycle() {
        return investCycle;
    }

    public void setInvestCycle(String investCycle) {
        this.investCycle = investCycle;
    }
    public String getPredictCashPayment() {
        return predictCashPayment;
    }

    public void setPredictCashPayment(String predictCashPayment) {
        this.predictCashPayment = predictCashPayment;
    }
    public String getTaxCostPredict() {
        return taxCostPredict;
    }

    public void setTaxCostPredict(String taxCostPredict) {
        this.taxCostPredict = taxCostPredict;
    }
    public String getOtherFeePredict() {
        return otherFeePredict;
    }

    public void setOtherFeePredict(String otherFeePredict) {
        this.otherFeePredict = otherFeePredict;
    }
    public String getFinanceCostPredict() {
        return financeCostPredict;
    }

    public void setFinanceCostPredict(String financeCostPredict) {
        this.financeCostPredict = financeCostPredict;
    }
    public String getProfitPredict() {
        return profitPredict;
    }

    public void setProfitPredict(String profitPredict) {
        this.profitPredict = profitPredict;
    }
    public String getProfitRatePredict() {
        return profitRatePredict;
    }

    public void setProfitRatePredict(String profitRatePredict) {
        this.profitRatePredict = profitRatePredict;
    }
    public String getYearProfitRatePredict() {
        return yearProfitRatePredict;
    }

    public void setYearProfitRatePredict(String yearProfitRatePredict) {
        this.yearProfitRatePredict = yearProfitRatePredict;
    }
    public Integer getSubmitReportFlag() {
        return submitReportFlag;
    }

    public void setSubmitReportFlag(Integer submitReportFlag) {
        this.submitReportFlag = submitReportFlag;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }
    
}
