package com.ejianc.business.invest.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 项目投资-投资收益-子表
 * 
 * @author generator
 * 
 */
public class IncomeDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    

    private Long incomeId; // 投资收益主表id
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date incomeMonth; // 投资收益主表月份
    private Long investPersonId; // 投资人
    private String investPersonName; // 投资人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date investDate; // 投资时间
    private BigDecimal investMny; // 投资金额（元）
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date incomeDate; // 分红时间
    private BigDecimal incomeMny; // 投资收益（元）
    private String memo; // 备注
    


    public Long getIncomeId() {
        return incomeId;
    }

    public void setIncomeId(Long incomeId) {
        this.incomeId = incomeId;
    }
    public Date getIncomeMonth() {
        return incomeMonth;
    }

    public void setIncomeMonth(Date incomeMonth) {
        this.incomeMonth = incomeMonth;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getInvestPersonId() {
        return investPersonId;
    }

    @ReferDeserialTransfer
    public void setInvestPersonId(Long investPersonId) {
        this.investPersonId = investPersonId;
    }
    public String getInvestPersonName() {
        return investPersonName;
    }

    public void setInvestPersonName(String investPersonName) {
        this.investPersonName = investPersonName;
    }
    public Date getInvestDate() {
        return investDate;
    }

    public void setInvestDate(Date investDate) {
        this.investDate = investDate;
    }
    public BigDecimal getInvestMny() {
        return investMny;
    }

    public void setInvestMny(BigDecimal investMny) {
        this.investMny = investMny;
    }
    public Date getIncomeDate() {
        return incomeDate;
    }

    public void setIncomeDate(Date incomeDate) {
        this.incomeDate = incomeDate;
    }
    public BigDecimal getIncomeMny() {
        return incomeMny;
    }

    public void setIncomeMny(BigDecimal incomeMny) {
        this.incomeMny = incomeMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
