package com.ejianc.business.cost.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 成本会计-项目明细账
 * 
 * @author generator
 * 
 */
public class ProjectDetailBillVO {
    private static final long serialVersionUID = 1L;
    
    private Long Id;
    private String billCode; // 单据编号
    private Long projectId; // 项目id
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date date; // 日期

    private String abstractMemo; // 摘要
    private BigDecimal receiveMny; // 收款
    private BigDecimal paymentMny; // 付款
    private BigDecimal balance; // 余额
    private Integer feeType; // 费用类型 0:非付款申请 1:付款申请
    private String memo; // 备注

    public Integer getFeeType() {
        return feeType;
    }

    public void setFeeType(Integer feeType) {
        this.feeType = feeType;
    }

    public Long getId() {
        return Id;
    }

    public void setId(Long id) {
        Id = id;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getAbstractMemo() {
        return abstractMemo;
    }

    public void setAbstractMemo(String abstractMemo) {
        this.abstractMemo = abstractMemo;
    }

    public BigDecimal getReceiveMny() {
        return receiveMny;
    }

    public void setReceiveMny(BigDecimal receiveMny) {
        this.receiveMny = receiveMny;
    }

    public BigDecimal getPaymentMny() {
        return paymentMny;
    }

    public void setPaymentMny(BigDecimal paymentMny) {
        this.paymentMny = paymentMny;
    }

    public BigDecimal getBalance() {
        return balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
}
