package com.ejianc.business.bid.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 投标管理-项目报名实体
 * 
 * @author generator
 * 
 */
public class ProjectRegistrationVO extends BaseVO {

    private static final long serialVersionUID = 5205390461537231747L;
    private String projectName; // 工程名称
    private String sectionName; // 标段
    private String area; // 地区
    private BigDecimal mny; // 金额
    private String memo; // 备注
    private Long followPersonId; // 编制人id
    private String followPerson; // 地区
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date billDate; // 编制日期
    private String billCode; // 编码
    private Integer billState; // 单据状态
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date effectiveDate; // 生效日期
    private String checkStatus; //出纳复核状态：0-待复核，1-已复核

    private Long provinceId; // 省份id
    private String provinceCode; // 省份编码
    private String provinceName; // 省份名称
    private Long cityId; // 地级市id
    private String cityCode; // 地级市编码
    private String cityName; // 地级市名称
    private Long regionId; // 项目所属大区id
    private String regionCode; // 项目所属大区编码
    private String regionName; // 项目所属大区名称
    private String mnyStr; // 项目产值大写
    private BigDecimal biddingFee; // 标书费用
    private BigDecimal qualificationFee; // 资质费用/商务费用


    private Integer updateCheckStatusFlag = 0; //是否可以修改复核状态：0-否、1-是

    public Long getProvinceId() {
        return provinceId;
    }

    public void setProvinceId(Long provinceId) {
        this.provinceId = provinceId;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getProvinceName() {
        return provinceName;
    }

    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }

    public Long getCityId() {
        return cityId;
    }

    public void setCityId(Long cityId) {
        this.cityId = cityId;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getRegionCode() {
        return regionCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    public String getRegionName() {
        return regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public Long getRegionId() {
        return regionId;
    }

    public void setRegionId(Long regionId) {
        this.regionId = regionId;
    }

    public String getMnyStr() {
        return mnyStr;
    }

    public void setMnyStr(String mnyStr) {
        this.mnyStr = mnyStr;
    }

    public BigDecimal getBiddingFee() {
        return biddingFee;
    }

    public void setBiddingFee(BigDecimal biddingFee) {
        this.biddingFee = biddingFee;
    }

    public BigDecimal getQualificationFee() {
        return qualificationFee;
    }

    public void setQualificationFee(BigDecimal qualificationFee) {
        this.qualificationFee = qualificationFee;
    }

    public Integer getUpdateCheckStatusFlag() {
        return updateCheckStatusFlag;
    }

    public void setUpdateCheckStatusFlag(Integer updateCheckStatusFlag) {
        this.updateCheckStatusFlag = updateCheckStatusFlag;
    }

    public String getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(String checkStatus) {
        this.checkStatus = checkStatus;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getSectionName() {
        return sectionName;
    }

    public void setSectionName(String sectionName) {
        this.sectionName = sectionName;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getFollowPersonId() {
        return followPersonId;
    }

    public void setFollowPersonId(Long followPersonId) {
        this.followPersonId = followPersonId;
    }
    public String getFollowPerson() {
        return followPerson;
    }

    public void setFollowPerson(String followPerson) {
        this.followPerson = followPerson;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    
}
