package com.ejianc.business.finance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.finance.vo.OccupyDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 出纳资金-占用资金表-主表
 * 
 * @author generator
 * 
 */
public class OccupyVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date date; // 日期
    private BigDecimal occupyMny; // 资金占用总计金额
    private BigDecimal upMny; // 当日资金占用增加
    private BigDecimal downMny; // 当日资金占用减少
    private BigDecimal projectMny; // 工程款占用合计
    private BigDecimal bailMny; // 保证金占用合计
    private BigDecimal materialMny; // 代付材料款占用合计
    private BigDecimal otherMny; // 其他占用合计
    
    private List<OccupyDetailVO> occupyDetailList = new ArrayList<>(); // 出纳资金-占用资金表-子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }
    public BigDecimal getOccupyMny() {
        return occupyMny;
    }

    public void setOccupyMny(BigDecimal occupyMny) {
        this.occupyMny = occupyMny;
    }
    public BigDecimal getUpMny() {
        return upMny;
    }

    public void setUpMny(BigDecimal upMny) {
        this.upMny = upMny;
    }
    public BigDecimal getDownMny() {
        return downMny;
    }

    public void setDownMny(BigDecimal downMny) {
        this.downMny = downMny;
    }
    public BigDecimal getProjectMny() {
        return projectMny;
    }

    public void setProjectMny(BigDecimal projectMny) {
        this.projectMny = projectMny;
    }
    public BigDecimal getBailMny() {
        return bailMny;
    }

    public void setBailMny(BigDecimal bailMny) {
        this.bailMny = bailMny;
    }
    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }
    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }
    
     public List<OccupyDetailVO> getOccupyDetailList() {
        return occupyDetailList;
     }

     public void setOccupyDetailList(List<OccupyDetailVO> occupyDetailList) {
        this.occupyDetailList = occupyDetailList;
     }
}
