package com.ejianc.business.asset.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.asset.vo.PayReimburseDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 资产管理-费用报销
 * 
 * @author generator
 * 
 */
public class PayReimburseVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    private String memo; // 备注
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime; // 经办时间
    private String dependOnProject; // 属于项目:1-是，0-否
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long bearDeptId; // 费用承担部门id
    private String bearDept; // 费用承担部门
    private Integer payType; // 付款类型：1-组织付款，2- 项目付款
    private Long payUnitId; // 付款单位id
    private String payUnitName; // 付款单位
    private BigDecimal applyMny; // 申请金额
    private String applyMnyCn; // 申请金额大写
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyTime; // 申请时间
    private BigDecimal reimburseMmy; // 报销费用（含本期）
    private BigDecimal cumulativeMny; // 累计报销
    private String payReason; // 报销事由
    private Long applyUserId; // 申请人
    private String applyUserName; // 申请人名称
    private String subFeeTypeNames; // 费用类别汇总(子表)
    private String subFeeTypeIds; // 费用类型ids
    private Integer payStatus; // 支付状态：1-未支付，2-已支付
    private BigDecimal payMny; // 支付金额
    private String accountName; // 账户名称
    private String accountNum; // 银行账号
    private String accountBank; // 开户行
    private String billStateName; // 单据状态名称
    private Integer reimburseType; // 报销费用类型 1-项目管理 2-公司管理 3-资产管理


    private List<PayReimburseDetailVO> detailList = new ArrayList<>(); // 资产管理-费用报销子表

    public Integer getReimburseType() {
        return reimburseType;
    }

    public void setReimburseType(Integer reimburseType) {
        this.reimburseType = reimburseType;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }
    public String getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(String dependOnProject) {
        this.dependOnProject = dependOnProject;
    }
    @ReferSerialTransfer(referCode="asset-project-approval")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode="idm-dept")
    public Long getBearDeptId() {
        return bearDeptId;
    }
    @ReferDeserialTransfer
    public void setBearDeptId(Long bearDeptId) {
        this.bearDeptId = bearDeptId;
    }
    public String getBearDept() {
        return bearDept;
    }

    public void setBearDept(String bearDept) {
        this.bearDept = bearDept;
    }
    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPayUnitId() {
        return payUnitId;
    }
    @ReferDeserialTransfer
    public void setPayUnitId(Long payUnitId) {
        this.payUnitId = payUnitId;
    }
    public String getPayUnitName() {
        return payUnitName;
    }

    public void setPayUnitName(String payUnitName) {
        this.payUnitName = payUnitName;
    }
    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    public String getApplyMnyCn() {
        return applyMnyCn;
    }

    public void setApplyMnyCn(String applyMnyCn) {
        this.applyMnyCn = applyMnyCn;
    }
    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }
    public BigDecimal getReimburseMmy() {
        return reimburseMmy;
    }

    public void setReimburseMmy(BigDecimal reimburseMmy) {
        this.reimburseMmy = reimburseMmy;
    }
    public BigDecimal getCumulativeMny() {
        return cumulativeMny;
    }

    public void setCumulativeMny(BigDecimal cumulativeMny) {
        this.cumulativeMny = cumulativeMny;
    }
    public String getPayReason() {
        return payReason;
    }

    public void setPayReason(String payReason) {
        this.payReason = payReason;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getApplyUserId() {
        return applyUserId;
    }

    @ReferDeserialTransfer
    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }
    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }
    public String getSubFeeTypeNames() {
        return subFeeTypeNames;
    }

    public void setSubFeeTypeNames(String subFeeTypeNames) {
        this.subFeeTypeNames = subFeeTypeNames;
    }
    public String getSubFeeTypeIds() {
        return subFeeTypeIds;
    }

    public void setSubFeeTypeIds(String subFeeTypeIds) {
        this.subFeeTypeIds = subFeeTypeIds;
    }
    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }
    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }
    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }

    public List<PayReimburseDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<PayReimburseDetailVO> detailList) {
        this.detailList = detailList;
    }
}
