package com.ejianc.business.oa.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 人力行政-证书档案
 * 
 * @author generator
 * 
 */
public class CertRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private String humanTypeName; // 人员类别
    private String humanPayName; // 姓名
    private String phone; // 移动电话
    private Integer sex; // 性别 1：男 2：女
    private String sexName; // 性别 1：男 2：女
    private Long orgId; // 组织ID
    private String orgName; // 组织
    private String idCard; // 身份证号码
    private String major; // 所学专业
    private String educated; // 最高学历
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Integer humanType; // 人员类别（1内部2外部）
    private Long humanPayId; // 姓名
    public String getSexName() {
        return sexName;
    }

    private String cert; // 证书情况
    private String certName; // 证书情况


    private Long changeId; // 变更单主键
    private Integer changeState; // 变更状态(0-未变更1-变更中2-已变更)
    //
    private Boolean latestFlag; // 是否最新版本
    private Boolean enableState; // 是否生效
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date effectDate; // 生效时间

    private Integer taskVersion; // 版本号
    //
    private Integer beforeTaskVersion; // 历史版本号（记录值，变更时记录之前的版本号）

    private Long lastTaskId; // 上一版本主键（变更时赋值）
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date oneTime; // 第一版本创建时间（
    private Long baseTaskId; // 原始版本主键（用于展示变更记录）

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate; // 变更日期
    private Long changeEmployeeId; // 变更经办人
    private String changeEmployeeName; // 变更经办人名称
    private String changeReason; // 变更原因

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeEffectDate; // 变更生效时间

    private String changeStateName; // 变更状态名称
    private String billStateName; // 单据状态名称

    private List<CertRecordRecordVO> recordList = new ArrayList<>(); // 变更记录表


    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Integer getChangeState() {
        return changeState;
    }

    public void setChangeState(Integer changeState) {
        this.changeState = changeState;
    }

    public Boolean getLatestFlag() {
        return latestFlag;
    }

    public void setLatestFlag(Boolean latestFlag) {
        this.latestFlag = latestFlag;
    }

    public Boolean getEnableState() {
        return enableState;
    }

    public void setEnableState(Boolean enableState) {
        this.enableState = enableState;
    }

    public Date getEffectDate() {
        return effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }

    public Integer getTaskVersion() {
        return taskVersion;
    }

    public void setTaskVersion(Integer taskVersion) {
        this.taskVersion = taskVersion;
    }

    public Integer getBeforeTaskVersion() {
        return beforeTaskVersion;
    }

    public void setBeforeTaskVersion(Integer beforeTaskVersion) {
        this.beforeTaskVersion = beforeTaskVersion;
    }

    public Long getLastTaskId() {
        return lastTaskId;
    }

    public void setLastTaskId(Long lastTaskId) {
        this.lastTaskId = lastTaskId;
    }

    public Date getOneTime() {
        return oneTime;
    }

    public void setOneTime(Date oneTime) {
        this.oneTime = oneTime;
    }

    public Long getBaseTaskId() {
        return baseTaskId;
    }

    public void setBaseTaskId(Long baseTaskId) {
        this.baseTaskId = baseTaskId;
    }

    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getChangeEmployeeId() {
        return changeEmployeeId;
    }
    @ReferDeserialTransfer
    public void setChangeEmployeeId(Long changeEmployeeId) {
        this.changeEmployeeId = changeEmployeeId;
    }

    public String getChangeEmployeeName() {
        return changeEmployeeName;
    }

    public void setChangeEmployeeName(String changeEmployeeName) {
        this.changeEmployeeName = changeEmployeeName;
    }

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public Date getChangeEffectDate() {
        return changeEffectDate;
    }

    public void setChangeEffectDate(Date changeEffectDate) {
        this.changeEffectDate = changeEffectDate;
    }

    public String getChangeStateName() {
        return changeStateName;
    }

    public void setChangeStateName(String changeStateName) {
        this.changeStateName = changeStateName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public List<CertRecordRecordVO> getRecordList() {
        return recordList;
    }

    public void setRecordList(List<CertRecordRecordVO> recordList) {
        this.recordList = recordList;
    }


    public String getCertName() {
        return certName;
    }

    public void setCertName(String certName) {
        this.certName = certName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getCert() {
        return cert;
    }
    @ReferDeserialTransfer
    public void setCert(String cert) {
        this.cert = cert;
    }

    public Integer getHumanType() {
        return humanType;
    }

    public void setHumanType(Integer humanType) {
        this.humanType = humanType;
    }

    @ReferSerialTransfer(referCode = "bfyj-cert-human")
    public Long getHumanPayId() {
        return humanPayId;
    }
    @ReferDeserialTransfer
    public void setHumanPayId(Long humanPayId) {
        this.humanPayId = humanPayId;
    }

    public void setSexName(String sexName) {
        this.sexName = sexName;
    }

    private List<CertRecordDetailVO> certRecordDetailList = new ArrayList<>(); // 人力行政-证书档案-证件信息

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getHumanTypeName() {
        return humanTypeName;
    }

    public void setHumanTypeName(String humanTypeName) {
        this.humanTypeName = humanTypeName;
    }
    public String getHumanPayName() {
        return humanPayName;
    }

    public void setHumanPayName(String humanPayName) {
        this.humanPayName = humanPayName;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
    public String getMajor() {
        return major;
    }

    public void setMajor(String major) {
        this.major = major;
    }
    public String getEducated() {
        return educated;
    }

    public void setEducated(String educated) {
        this.educated = educated;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
     public List<CertRecordDetailVO> getCertRecordDetailList() {
        return certRecordDetailList;
     }

     public void setCertRecordDetailList(List<CertRecordDetailVO> certRecordDetailList) {
        this.certRecordDetailList = certRecordDetailList;
     }
}
