package com.ejianc.business.oa.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.oa.vo.OutstoreDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 人力行政-物品出库单
 * 
 * @author generator
 * 
 */
public class OutstoreVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    private Long orgId; // 出库组织id
    private String orgCode; // 组织编码
    private String orgName; // 出库组织名称
    private Long outStoreId; // 出库仓库id
    private String outStoreName; // 出库仓库名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date outDate; // 出库日期
    private String useFor; // 用途
    private Long inStoreId; // 调入仓库id
    private String inStoreName; // 调入仓库名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date inStoreDate; // 入库日期
    private Long inOrgId; // 调入组织id、领用部门
    private String inOrgCode; // 调入组织编码
    private String inOrgName; // 调入组织名称
    private Long recipientId; // 领用人
    private String recipientName; // 领用人名称
    private Integer outStoreType; // 出库单类型：0-调拨出库 1-出库单
    private String memo; // 备注
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date confirmTime; // 经办时间
    
    private List<OutstoreDetailVO> detailList = new ArrayList<>(); // 人力行政-物品出库单子表

    private String billStateName;

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode = "oa-store")
    public Long getOutStoreId() {
        return outStoreId;
    }
    @ReferDeserialTransfer
    public void setOutStoreId(Long outStoreId) {
        this.outStoreId = outStoreId;
    }
    public String getOutStoreName() {
        return outStoreName;
    }

    public void setOutStoreName(String outStoreName) {
        this.outStoreName = outStoreName;
    }
    public Date getOutDate() {
        return outDate;
    }

    public void setOutDate(Date outDate) {
        this.outDate = outDate;
    }
    public String getUseFor() {
        return useFor;
    }

    public void setUseFor(String useFor) {
        this.useFor = useFor;
    }
    @ReferSerialTransfer(referCode = "oa-store")
    public Long getInStoreId() {
        return inStoreId;
    }

    @ReferDeserialTransfer
    public void setInStoreId(Long inStoreId) {
        this.inStoreId = inStoreId;
    }
    public String getInStoreName() {
        return inStoreName;
    }

    public void setInStoreName(String inStoreName) {
        this.inStoreName = inStoreName;
    }
    public Date getInStoreDate() {
        return inStoreDate;
    }

    public void setInStoreDate(Date inStoreDate) {
        this.inStoreDate = inStoreDate;
    }
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getInOrgId() {
        return inOrgId;
    }
    @ReferDeserialTransfer
    public void setInOrgId(Long inOrgId) {
        this.inOrgId = inOrgId;
    }
    public String getInOrgCode() {
        return inOrgCode;
    }

    public void setInOrgCode(String inOrgCode) {
        this.inOrgCode = inOrgCode;
    }
    public String getInOrgName() {
        return inOrgName;
    }

    public void setInOrgName(String inOrgName) {
        this.inOrgName = inOrgName;
    }
    public Integer getOutStoreType() {
        return outStoreType;
    }

    public void setOutStoreType(Integer outStoreType) {
        this.outStoreType = outStoreType;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public List<OutstoreDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<OutstoreDetailVO> detailList) {
        this.detailList = detailList;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getRecipientId() {
        return recipientId;
    }

    @ReferDeserialTransfer
    public void setRecipientId(Long recipientId) {
        this.recipientId = recipientId;
    }

    public String getRecipientName() {
        return recipientName;
    }

    public void setRecipientName(String recipientName) {
        this.recipientName = recipientName;
    }
}
