package com.ejianc.business.oa.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 人力行政-员工入职审批表记录
 * 
 * @author generator
 * 
 */
public class EmployeeIntoRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long employeeId; // 员工id
    private String code; // 员工编号
    private String name; // 员工名称
    private Integer sex; // 性别 1：男 2：女
    private Integer age; // 年龄
    private Long orgId; // 组织ID
    private String orgName; // 组织
    private Long deptId; // 部门ID
    private String deptName; // 部门
    private Long postId; // 主职ID
    private String postName; // 主职
    private Integer rank; // 职级
    private String rankName; // 职级
    private String nation; // 民族
    private String height; // 身高
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date birthDate; // 出生日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date intoDate; // 入职日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date tryDate; // 试用日期
    private String origin; // 籍贯
    private Integer politicsId; // 政治面貌
    private String politicsName; // 政治面貌
    private Integer maritalStatusId; // 婚姻状况
    private String maritalStatusName; // 婚姻状况
    private String graduateSchool; // 毕业院校
    private String major; // 所学专业
    private String educated; // 最高学历
    private String idCard; // 身份证号码
    private String idAddress; // 身份证地址
    private String nowAddress; // 现居住地址
    private BigDecimal winterNum; // 冬季工时
    private BigDecimal summerNum; // 夏季工时
    private String phone; // 移动电话
    private String email; // 邮箱
    private String urgentName; // 紧急联系人姓名
    private String urgentRelational; // 紧急联系人关系
    private String urgentPhone; // 紧急联系人电话
    private BigDecimal salary; // 薪资标准
    private BigDecimal basicSalary; // 基本薪资
    private BigDecimal postSalary; // 岗位薪资
    private BigDecimal levelSalary; // 层级薪资
    private String tryStandard; // 试用标准
    private Integer insuredFlag; // 是否缴纳保险
    private String insuredFlagName; // 是否缴纳保险
    private String cert; // 证书情况
    private String certName; // 证书情况
    private BigDecimal educatedSalary; // 学历津贴
    private Integer state; // 状态标识（0：离职，1：在职）
    private String changeCode; // 变更单号
    private Long changeId; // 变更主键
    private Integer changeVersion; // 变更版本
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date formalDate; // 转正日期
    private Integer contractTerm; // 合同年限
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date contractDateBegin; // 合同时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date contractDateEnd; // 合同时间
    private BigDecimal certSalary; // 证书津贴
    private BigDecimal sportSalary; // 交通补助
    private Long yearSalaryId; // 司龄津贴
    private BigDecimal yearSalary; // 司龄津贴
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date yearChangeDate; // 司龄调整月份
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date removeDate; // 实际离职日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date salaryEndDate; // 薪资核算截止日
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date insuredEndDate; // 保险最后缴纳月份
    private Long oldDeptId; // 部门ID
    private String oldDeptName; // 部门
    private Long oldPostId; // 主职ID
    private String oldPostName; // 主职
    private Integer oldRank; // 职级
    private String oldRankName; // 职级
    private BigDecimal oldSalary; // 薪资标准
    private BigDecimal oldBasicSalary; // 基本薪资
    private BigDecimal oldPostSalary; // 岗位薪资
    private BigDecimal oldLevelSalary; // 层级薪资
    private BigDecimal oldCertSalary; // 证书津贴
    private BigDecimal oldEducatedSalary; // 学历津贴
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date winterTimeStart; // 冬季工时起
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date winterTimeEnd; // 冬季工时止
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date summerTimeStart; // 夏季工时起
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date summerTimeEnd; // 夏季工时止

    private String winterNumSelect; // 冬季工时 冬季 1：8:30-16:30、 2：9:00-17:00
    private String summerNumSelect; // 夏季工时 夏季 1：8:30-17:00 、2：9:00-17:00
    private BigDecimal otherNeedPay; // 其他应付
    private BigDecimal yearSalaryInit; // 司龄津贴初始值

    public BigDecimal getYearSalaryInit() {
        return yearSalaryInit;
    }

    public void setYearSalaryInit(BigDecimal yearSalaryInit) {
        this.yearSalaryInit = yearSalaryInit;
    }
    public BigDecimal getOtherNeedPay() {
        return otherNeedPay;
    }

    public void setOtherNeedPay(BigDecimal otherNeedPay) {
        this.otherNeedPay = otherNeedPay;
    }

    public String getWinterNumSelect() {
        return winterNumSelect;
    }

    public void setWinterNumSelect(String winterNumSelect) {
        this.winterNumSelect = winterNumSelect;
    }

    public String getSummerNumSelect() {
        return summerNumSelect;
    }

    public void setSummerNumSelect(String summerNumSelect) {
        this.summerNumSelect = summerNumSelect;
    }

    public Date getWinterTimeStart() {
        return winterTimeStart;
    }

    public void setWinterTimeStart(Date winterTimeStart) {
        this.winterTimeStart = winterTimeStart;
    }

    public Date getWinterTimeEnd() {
        return winterTimeEnd;
    }

    public void setWinterTimeEnd(Date winterTimeEnd) {
        this.winterTimeEnd = winterTimeEnd;
    }

    public Date getSummerTimeStart() {
        return summerTimeStart;
    }

    public void setSummerTimeStart(Date summerTimeStart) {
        this.summerTimeStart = summerTimeStart;
    }

    public Date getSummerTimeEnd() {
        return summerTimeEnd;
    }

    public void setSummerTimeEnd(Date summerTimeEnd) {
        this.summerTimeEnd = summerTimeEnd;
    }

    public Date getFormalDate() {
        return formalDate;
    }

    public void setFormalDate(Date formalDate) {
        this.formalDate = formalDate;
    }

    public Integer getContractTerm() {
        return contractTerm;
    }

    public void setContractTerm(Integer contractTerm) {
        this.contractTerm = contractTerm;
    }

    public Date getContractDateBegin() {
        return contractDateBegin;
    }

    public void setContractDateBegin(Date contractDateBegin) {
        this.contractDateBegin = contractDateBegin;
    }

    public Date getContractDateEnd() {
        return contractDateEnd;
    }

    public void setContractDateEnd(Date contractDateEnd) {
        this.contractDateEnd = contractDateEnd;
    }

    public BigDecimal getCertSalary() {
        return certSalary;
    }

    public void setCertSalary(BigDecimal certSalary) {
        this.certSalary = certSalary;
    }

    public BigDecimal getSportSalary() {
        return sportSalary;
    }

    public void setSportSalary(BigDecimal sportSalary) {
        this.sportSalary = sportSalary;
    }

    @ReferSerialTransfer(referCode="bfyj-year-salary")
    public Long getYearSalaryId() {
        return yearSalaryId;
    }
    @ReferDeserialTransfer
    public void setYearSalaryId(Long yearSalaryId) {
        this.yearSalaryId = yearSalaryId;
    }

    public BigDecimal getYearSalary() {
        return yearSalary;
    }

    public void setYearSalary(BigDecimal yearSalary) {
        this.yearSalary = yearSalary;
    }

    public Date getYearChangeDate() {
        return yearChangeDate;
    }

    public void setYearChangeDate(Date yearChangeDate) {
        this.yearChangeDate = yearChangeDate;
    }

    public Date getRemoveDate() {
        return removeDate;
    }

    public void setRemoveDate(Date removeDate) {
        this.removeDate = removeDate;
    }

    public Date getSalaryEndDate() {
        return salaryEndDate;
    }

    public void setSalaryEndDate(Date salaryEndDate) {
        this.salaryEndDate = salaryEndDate;
    }

    public Date getInsuredEndDate() {
        return insuredEndDate;
    }

    public void setInsuredEndDate(Date insuredEndDate) {
        this.insuredEndDate = insuredEndDate;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getOldDeptId() {
        return oldDeptId;
    }
    @ReferDeserialTransfer
    public void setOldDeptId(Long oldDeptId) {
        this.oldDeptId = oldDeptId;
    }

    public String getOldDeptName() {
        return oldDeptName;
    }

    public void setOldDeptName(String oldDeptName) {
        this.oldDeptName = oldDeptName;
    }
    @ReferSerialTransfer(referCode="idm_post")
    public Long getOldPostId() {
        return oldPostId;
    }
    @ReferDeserialTransfer
    public void setOldPostId(Long oldPostId) {
        this.oldPostId = oldPostId;
    }

    public String getOldPostName() {
        return oldPostName;
    }

    public void setOldPostName(String oldPostName) {
        this.oldPostName = oldPostName;
    }

    public Integer getOldRank() {
        return oldRank;
    }

    public void setOldRank(Integer oldRank) {
        this.oldRank = oldRank;
    }

    public String getOldRankName() {
        return oldRankName;
    }

    public void setOldRankName(String oldRankName) {
        this.oldRankName = oldRankName;
    }

    public BigDecimal getOldSalary() {
        return oldSalary;
    }

    public void setOldSalary(BigDecimal oldSalary) {
        this.oldSalary = oldSalary;
    }

    public BigDecimal getOldBasicSalary() {
        return oldBasicSalary;
    }

    public void setOldBasicSalary(BigDecimal oldBasicSalary) {
        this.oldBasicSalary = oldBasicSalary;
    }

    public BigDecimal getOldPostSalary() {
        return oldPostSalary;
    }

    public void setOldPostSalary(BigDecimal oldPostSalary) {
        this.oldPostSalary = oldPostSalary;
    }

    public BigDecimal getOldLevelSalary() {
        return oldLevelSalary;
    }

    public void setOldLevelSalary(BigDecimal oldLevelSalary) {
        this.oldLevelSalary = oldLevelSalary;
    }

    public BigDecimal getOldCertSalary() {
        return oldCertSalary;
    }

    public void setOldCertSalary(BigDecimal oldCertSalary) {
        this.oldCertSalary = oldCertSalary;
    }

    public BigDecimal getOldEducatedSalary() {
        return oldEducatedSalary;
    }

    public void setOldEducatedSalary(BigDecimal oldEducatedSalary) {
        this.oldEducatedSalary = oldEducatedSalary;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }


    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }
    public Integer getAge() {
        return age;
    }

    public void setAge(Integer age) {
        this.age = age;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDeptId() {
        return deptId;
    }
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    @ReferSerialTransfer(referCode="idm_post")
    public Long getPostId() {
        return postId;
    }
    @ReferDeserialTransfer
    public void setPostId(Long postId) {
        this.postId = postId;
    }
    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }
    public Integer getRank() {
        return rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }
    public String getRankName() {
        return rankName;
    }

    public void setRankName(String rankName) {
        this.rankName = rankName;
    }
    public String getNation() {
        return nation;
    }

    public void setNation(String nation) {
        this.nation = nation;
    }
    public String getHeight() {
        return height;
    }

    public void setHeight(String height) {
        this.height = height;
    }
    public Date getBirthDate() {
        return birthDate;
    }

    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }
    public Date getIntoDate() {
        return intoDate;
    }

    public void setIntoDate(Date intoDate) {
        this.intoDate = intoDate;
    }
    public Date getTryDate() {
        return tryDate;
    }

    public void setTryDate(Date tryDate) {
        this.tryDate = tryDate;
    }
    public String getOrigin() {
        return origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }
    public Integer getPoliticsId() {
        return politicsId;
    }

    public void setPoliticsId(Integer politicsId) {
        this.politicsId = politicsId;
    }
    public String getPoliticsName() {
        return politicsName;
    }

    public void setPoliticsName(String politicsName) {
        this.politicsName = politicsName;
    }

    public Integer getMaritalStatusId() {
        return maritalStatusId;
    }

    public void setMaritalStatusId(Integer maritalStatusId) {
        this.maritalStatusId = maritalStatusId;
    }

    public String getMaritalStatusName() {
        return maritalStatusName;
    }

    public void setMaritalStatusName(String maritalStatusName) {
        this.maritalStatusName = maritalStatusName;
    }

    public String getGraduateSchool() {
        return graduateSchool;
    }

    public void setGraduateSchool(String graduateSchool) {
        this.graduateSchool = graduateSchool;
    }
    public String getMajor() {
        return major;
    }

    public void setMajor(String major) {
        this.major = major;
    }
    public String getEducated() {
        return educated;
    }

    public void setEducated(String educated) {
        this.educated = educated;
    }
    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
    public String getIdAddress() {
        return idAddress;
    }

    public void setIdAddress(String idAddress) {
        this.idAddress = idAddress;
    }
    public String getNowAddress() {
        return nowAddress;
    }

    public void setNowAddress(String nowAddress) {
        this.nowAddress = nowAddress;
    }
    public BigDecimal getWinterNum() {
        return winterNum;
    }

    public void setWinterNum(BigDecimal winterNum) {
        this.winterNum = winterNum;
    }
    public BigDecimal getSummerNum() {
        return summerNum;
    }

    public void setSummerNum(BigDecimal summerNum) {
        this.summerNum = summerNum;
    }
    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
    public String getUrgentName() {
        return urgentName;
    }

    public void setUrgentName(String urgentName) {
        this.urgentName = urgentName;
    }
    public String getUrgentRelational() {
        return urgentRelational;
    }

    public void setUrgentRelational(String urgentRelational) {
        this.urgentRelational = urgentRelational;
    }
    public String getUrgentPhone() {
        return urgentPhone;
    }

    public void setUrgentPhone(String urgentPhone) {
        this.urgentPhone = urgentPhone;
    }
    public BigDecimal getSalary() {
        return salary;
    }

    public void setSalary(BigDecimal salary) {
        this.salary = salary;
    }
    public BigDecimal getBasicSalary() {
        return basicSalary;
    }

    public void setBasicSalary(BigDecimal basicSalary) {
        this.basicSalary = basicSalary;
    }
    public BigDecimal getPostSalary() {
        return postSalary;
    }

    public void setPostSalary(BigDecimal postSalary) {
        this.postSalary = postSalary;
    }
    public BigDecimal getLevelSalary() {
        return levelSalary;
    }

    public void setLevelSalary(BigDecimal levelSalary) {
        this.levelSalary = levelSalary;
    }
    public String getTryStandard() {
        return tryStandard;
    }

    public void setTryStandard(String tryStandard) {
        this.tryStandard = tryStandard;
    }
    public Integer getInsuredFlag() {
        return insuredFlag;
    }

    public void setInsuredFlag(Integer insuredFlag) {
        this.insuredFlag = insuredFlag;
    }
    public String getInsuredFlagName() {
        return insuredFlagName;
    }

    public void setInsuredFlagName(String insuredFlagName) {
        this.insuredFlagName = insuredFlagName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getCert() {
        return cert;
    }
    @ReferDeserialTransfer
    public void setCert(String cert) {
        this.cert = cert;
    }
    public String getCertName() {
        return certName;
    }

    public void setCertName(String certName) {
        this.certName = certName;
    }
    public BigDecimal getEducatedSalary() {
        return educatedSalary;
    }

    public void setEducatedSalary(BigDecimal educatedSalary) {
        this.educatedSalary = educatedSalary;
    }
    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    
}
