package com.ejianc.business.cost.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 成本会计-项目对账单
 * 
 * @author generator
 * 
 */
public class ProjectBillVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 项目所属组织
    private String parentOrgCode; // 项目所属组织编码
    private String parentOrgName; // 项目所属组织名称
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private BigDecimal contractMny = BigDecimal.ZERO; // 合同金额
    private BigDecimal chargingReferMny = BigDecimal.ZERO; // 计费依据
    private BigDecimal taxLevyRate = BigDecimal.ZERO; // 税金征收率
    private BigDecimal mny = BigDecimal.ZERO; // 金额
    private BigDecimal difPlaceAdvanceTax = BigDecimal.ZERO; // 异地预缴税额
    private BigDecimal alreadyPayTax = BigDecimal.ZERO; // 已交税金
    private BigDecimal totalPayTax = BigDecimal.ZERO; // 累计已交税金

    private BigDecimal alreadyDeductTax = BigDecimal.ZERO; // 本次抵扣税额
    private BigDecimal totalDeductTax = BigDecimal.ZERO; // 累计抵扣税额
    private BigDecimal projectDeptTax = BigDecimal.ZERO; // 项目部应缴税小计
    private BigDecimal managementFeeRate = BigDecimal.ZERO; // 管理费征收率
    private BigDecimal managementFeeMny = BigDecimal.ZERO; // 管理费金额
    private BigDecimal noCostTicketLevy = BigDecimal.ZERO; // 无成本票预留
    private BigDecimal noCostTicketReservedLevyRate = BigDecimal.ZERO; // 无成本票预留征收率
    private BigDecimal noCostTicketReservedLevyMny = BigDecimal.ZERO; // 无成本票预留
    private BigDecimal otherChargeableMny = BigDecimal.ZERO; // 其他应收费用
    private BigDecimal projectDeptChargeableMny = BigDecimal.ZERO; // 项目部应交费小计
    private BigDecimal repaymentMny = BigDecimal.ZERO; // 本次回款金额
    private BigDecimal totalRepaymentMny = BigDecimal.ZERO; // 累计回款金额
    private BigDecimal billMny = BigDecimal.ZERO; // 本次对账金额
    private BigDecimal lastRepaymentTax = BigDecimal.ZERO; // 上次结余税额
    private BigDecimal deductTax = BigDecimal.ZERO; // 新增可抵扣税额
    private BigDecimal totalCanDeductTax = BigDecimal.ZERO; // 累计可抵扣税额
    private BigDecimal deductTaxCollect = BigDecimal.ZERO; // 现有抵扣税额合计
    private BigDecimal deductTaxCollectCash = BigDecimal.ZERO; // 现有抵扣税额合计转现金
    private BigDecimal leaveDeductTax = BigDecimal.ZERO; // 剩余可抵扣税额
    private BigDecimal needCost = BigDecimal.ZERO; // 本次需提供成本
    private BigDecimal costCollect = BigDecimal.ZERO; // 现有成本合计
    private BigDecimal useCost = BigDecimal.ZERO; // 本次使用成本
    private BigDecimal leaveUsableCost = BigDecimal.ZERO; // 剩余可用成本
    private BigDecimal lastBalanceCost = BigDecimal.ZERO; // 上次结余成本
    private BigDecimal specialTicketCost = BigDecimal.ZERO; // 新增专票成本
    private BigDecimal totalSpecialTicketCost = BigDecimal.ZERO; // 累计专票成本
    private BigDecimal commonTicketMny = BigDecimal.ZERO; // 新增普票成本
    private BigDecimal totalCommonTicketMny = BigDecimal.ZERO; // 累计普票成本
    private BigDecimal migrantWorkerCashCost = BigDecimal.ZERO; // 新增农民工工资成本
    private BigDecimal totalMigrantWorkerCashCost = BigDecimal.ZERO; // 累计农民工工资成本
    private BigDecimal deductLimit = BigDecimal.ZERO; // 本次抵扣上限（含预缴）
    private BigDecimal waitPassCost = BigDecimal.ZERO; // 待合格成本
    private BigDecimal waitPassDeductTax = BigDecimal.ZERO; // 待合格抵扣税额
    private BigDecimal invoiceMny = BigDecimal.ZERO; // 本次开票金额
    private BigDecimal totalInvoiceMny = BigDecimal.ZERO; // 累计开票金额
    private BigDecimal totalPaymentMny = BigDecimal.ZERO; // 累计回款金额
    private BigDecimal contractPaymentRate = BigDecimal.ZERO; // 合同回款比例
    private String memo; // 备注
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime; // 经办时间

    private List<Long> otherFeeIdList = new ArrayList<>(); // 其他费用单id列表
    private List<Long> payMigrantIdList = new ArrayList<>(); // 民工工资申请单id列表
    private List<Long> receiveIdList = new ArrayList<>(); // 收款登记单id列表
    private List<Long> InvoiceReceiveRegisterIdList = new ArrayList<>(); // 占用收票id列表
    private List<Long> InvoiceReceivePoolIdList = new ArrayList<>(); // 占用收票子表id列表
    private List<Long> InvoiceOpenRegistIdList = new ArrayList<>(); // 占用开票id列表
    private List<Long> prepaymentPaidIdList = new ArrayList<>(); // 预缴完税登记id列表
    private BigDecimal underpaymentMny; // 项目欠还款金额
    private BigDecimal planPaymentMny; // 预计还款金额

    public BigDecimal getUnderpaymentMny() {
        return underpaymentMny;
    }

    public void setUnderpaymentMny(BigDecimal underpaymentMny) {
        this.underpaymentMny = underpaymentMny;
    }

    public BigDecimal getPlanPaymentMny() {
        return planPaymentMny;
    }

    public void setPlanPaymentMny(BigDecimal planPaymentMny) {
        this.planPaymentMny = planPaymentMny;
    }
    public List<Long> getPrepaymentPaidIdList() {
        return prepaymentPaidIdList;
    }

    public void setPrepaymentPaidIdList(List<Long> prepaymentPaidIdList) {
        this.prepaymentPaidIdList = prepaymentPaidIdList;
    }

    public List<Long> getInvoiceReceivePoolIdList() {
        return InvoiceReceivePoolIdList;
    }

    public void setInvoiceReceivePoolIdList(List<Long> invoiceReceivePoolIdList) {
        InvoiceReceivePoolIdList = invoiceReceivePoolIdList;
    }

    public List<Long> getInvoiceOpenRegistIdList() {
        return InvoiceOpenRegistIdList;
    }

    public void setInvoiceOpenRegistIdList(List<Long> invoiceOpenRegistIdList) {
        InvoiceOpenRegistIdList = invoiceOpenRegistIdList;
    }

    public List<Long> getPayMigrantIdList() {
        return payMigrantIdList;
    }

    public void setPayMigrantIdList(List<Long> payMigrantIdList) {
        this.payMigrantIdList = payMigrantIdList;
    }

    public List<Long> getReceiveIdList() {
        return receiveIdList;
    }

    public void setReceiveIdList(List<Long> receiveIdList) {
        this.receiveIdList = receiveIdList;
    }

    public List<Long> getInvoiceReceiveRegisterIdList() {
        return InvoiceReceiveRegisterIdList;
    }

    public void setInvoiceReceiveRegisterIdList(List<Long> invoiceReceiveRegisterIdList) {
        InvoiceReceiveRegisterIdList = invoiceReceiveRegisterIdList;
    }

    public List<Long> getOtherFeeIdList() {
        return otherFeeIdList;
    }

    public void setOtherFeeIdList(List<Long> otherFeeIdList) {
        this.otherFeeIdList = otherFeeIdList;
    }

    private String billStateName; // 单据状态名称
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    @ReferSerialTransfer(referCode = "bfyj-market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getChargingReferMny() {
        return chargingReferMny;
    }

    public void setChargingReferMny(BigDecimal chargingReferMny) {
        this.chargingReferMny = chargingReferMny;
    }
    public BigDecimal getTaxLevyRate() {
        return taxLevyRate;
    }

    public void setTaxLevyRate(BigDecimal taxLevyRate) {
        this.taxLevyRate = taxLevyRate;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public BigDecimal getDifPlaceAdvanceTax() {
        return difPlaceAdvanceTax;
    }

    public void setDifPlaceAdvanceTax(BigDecimal difPlaceAdvanceTax) {
        this.difPlaceAdvanceTax = difPlaceAdvanceTax;
    }
    public BigDecimal getAlreadyPayTax() {
        return alreadyPayTax;
    }

    public void setAlreadyPayTax(BigDecimal alreadyPayTax) {
        this.alreadyPayTax = alreadyPayTax;
    }
    public BigDecimal getTotalPayTax() {
        return totalPayTax;
    }

    public void setTotalPayTax(BigDecimal totalPayTax) {
        this.totalPayTax = totalPayTax;
    }
    public BigDecimal getAlreadyDeductTax() {
        return alreadyDeductTax;
    }

    public void setAlreadyDeductTax(BigDecimal alreadyDeductTax) {
        this.alreadyDeductTax = alreadyDeductTax;
    }
    public BigDecimal getTotalDeductTax() {
        return totalDeductTax;
    }

    public void setTotalDeductTax(BigDecimal totalDeductTax) {
        this.totalDeductTax = totalDeductTax;
    }
    public BigDecimal getProjectDeptTax() {
        return projectDeptTax;
    }

    public void setProjectDeptTax(BigDecimal projectDeptTax) {
        this.projectDeptTax = projectDeptTax;
    }
    public BigDecimal getManagementFeeRate() {
        return managementFeeRate;
    }

    public void setManagementFeeRate(BigDecimal managementFeeRate) {
        this.managementFeeRate = managementFeeRate;
    }
    public BigDecimal getManagementFeeMny() {
        return managementFeeMny;
    }

    public void setManagementFeeMny(BigDecimal managementFeeMny) {
        this.managementFeeMny = managementFeeMny;
    }
    public BigDecimal getNoCostTicketLevy() {
        return noCostTicketLevy;
    }

    public void setNoCostTicketLevy(BigDecimal noCostTicketLevy) {
        this.noCostTicketLevy = noCostTicketLevy;
    }
    public BigDecimal getNoCostTicketReservedLevyRate() {
        return noCostTicketReservedLevyRate;
    }

    public void setNoCostTicketReservedLevyRate(BigDecimal noCostTicketReservedLevyRate) {
        this.noCostTicketReservedLevyRate = noCostTicketReservedLevyRate;
    }
    public BigDecimal getNoCostTicketReservedLevyMny() {
        return noCostTicketReservedLevyMny;
    }

    public void setNoCostTicketReservedLevyMny(BigDecimal noCostTicketReservedLevyMny) {
        this.noCostTicketReservedLevyMny = noCostTicketReservedLevyMny;
    }
    public BigDecimal getOtherChargeableMny() {
        return otherChargeableMny;
    }

    public void setOtherChargeableMny(BigDecimal otherChargeableMny) {
        this.otherChargeableMny = otherChargeableMny;
    }
    public BigDecimal getProjectDeptChargeableMny() {
        return projectDeptChargeableMny;
    }

    public void setProjectDeptChargeableMny(BigDecimal projectDeptChargeableMny) {
        this.projectDeptChargeableMny = projectDeptChargeableMny;
    }
    public BigDecimal getRepaymentMny() {
        return repaymentMny;
    }

    public void setRepaymentMny(BigDecimal repaymentMny) {
        this.repaymentMny = repaymentMny;
    }
    public BigDecimal getTotalRepaymentMny() {
        return totalRepaymentMny;
    }

    public void setTotalRepaymentMny(BigDecimal totalRepaymentMny) {
        this.totalRepaymentMny = totalRepaymentMny;
    }
    public BigDecimal getBillMny() {
        return billMny;
    }

    public void setBillMny(BigDecimal billMny) {
        this.billMny = billMny;
    }
    public BigDecimal getLastRepaymentTax() {
        return lastRepaymentTax;
    }

    public void setLastRepaymentTax(BigDecimal lastRepaymentTax) {
        this.lastRepaymentTax = lastRepaymentTax;
    }
    public BigDecimal getDeductTax() {
        return deductTax;
    }

    public void setDeductTax(BigDecimal deductTax) {
        this.deductTax = deductTax;
    }
    public BigDecimal getTotalCanDeductTax() {
        return totalCanDeductTax;
    }

    public void setTotalCanDeductTax(BigDecimal totalCanDeductTax) {
        this.totalCanDeductTax = totalCanDeductTax;
    }
    public BigDecimal getDeductTaxCollect() {
        return deductTaxCollect;
    }

    public void setDeductTaxCollect(BigDecimal deductTaxCollect) {
        this.deductTaxCollect = deductTaxCollect;
    }
    public BigDecimal getDeductTaxCollectCash() {
        return deductTaxCollectCash;
    }

    public void setDeductTaxCollectCash(BigDecimal deductTaxCollectCash) {
        this.deductTaxCollectCash = deductTaxCollectCash;
    }
    public BigDecimal getLeaveDeductTax() {
        return leaveDeductTax;
    }

    public void setLeaveDeductTax(BigDecimal leaveDeductTax) {
        this.leaveDeductTax = leaveDeductTax;
    }
    public BigDecimal getNeedCost() {
        return needCost;
    }

    public void setNeedCost(BigDecimal needCost) {
        this.needCost = needCost;
    }
    public BigDecimal getCostCollect() {
        return costCollect;
    }

    public void setCostCollect(BigDecimal costCollect) {
        this.costCollect = costCollect;
    }
    public BigDecimal getUseCost() {
        return useCost;
    }

    public void setUseCost(BigDecimal useCost) {
        this.useCost = useCost;
    }
    public BigDecimal getLeaveUsableCost() {
        return leaveUsableCost;
    }

    public void setLeaveUsableCost(BigDecimal leaveUsableCost) {
        this.leaveUsableCost = leaveUsableCost;
    }
    public BigDecimal getLastBalanceCost() {
        return lastBalanceCost;
    }

    public void setLastBalanceCost(BigDecimal lastBalanceCost) {
        this.lastBalanceCost = lastBalanceCost;
    }
    public BigDecimal getSpecialTicketCost() {
        return specialTicketCost;
    }

    public void setSpecialTicketCost(BigDecimal specialTicketCost) {
        this.specialTicketCost = specialTicketCost;
    }
    public BigDecimal getTotalSpecialTicketCost() {
        return totalSpecialTicketCost;
    }

    public void setTotalSpecialTicketCost(BigDecimal totalSpecialTicketCost) {
        this.totalSpecialTicketCost = totalSpecialTicketCost;
    }
    public BigDecimal getCommonTicketMny() {
        return commonTicketMny;
    }

    public void setCommonTicketMny(BigDecimal commonTicketMny) {
        this.commonTicketMny = commonTicketMny;
    }
    public BigDecimal getTotalCommonTicketMny() {
        return totalCommonTicketMny;
    }

    public void setTotalCommonTicketMny(BigDecimal totalCommonTicketMny) {
        this.totalCommonTicketMny = totalCommonTicketMny;
    }
    public BigDecimal getMigrantWorkerCashCost() {
        return migrantWorkerCashCost;
    }

    public void setMigrantWorkerCashCost(BigDecimal migrantWorkerCashCost) {
        this.migrantWorkerCashCost = migrantWorkerCashCost;
    }
    public BigDecimal getTotalMigrantWorkerCashCost() {
        return totalMigrantWorkerCashCost;
    }

    public void setTotalMigrantWorkerCashCost(BigDecimal totalMigrantWorkerCashCost) {
        this.totalMigrantWorkerCashCost = totalMigrantWorkerCashCost;
    }
    public BigDecimal getDeductLimit() {
        return deductLimit;
    }

    public void setDeductLimit(BigDecimal deductLimit) {
        this.deductLimit = deductLimit;
    }
    public BigDecimal getWaitPassCost() {
        return waitPassCost;
    }

    public void setWaitPassCost(BigDecimal waitPassCost) {
        this.waitPassCost = waitPassCost;
    }
    public BigDecimal getWaitPassDeductTax() {
        return waitPassDeductTax;
    }

    public void setWaitPassDeductTax(BigDecimal waitPassDeductTax) {
        this.waitPassDeductTax = waitPassDeductTax;
    }
    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }
    public BigDecimal getTotalInvoiceMny() {
        return totalInvoiceMny;
    }

    public void setTotalInvoiceMny(BigDecimal totalInvoiceMny) {
        this.totalInvoiceMny = totalInvoiceMny;
    }
    public BigDecimal getTotalPaymentMny() {
        return totalPaymentMny;
    }

    public void setTotalPaymentMny(BigDecimal totalPaymentMny) {
        this.totalPaymentMny = totalPaymentMny;
    }
    public BigDecimal getContractPaymentRate() {
        return contractPaymentRate;
    }

    public void setContractPaymentRate(BigDecimal contractPaymentRate) {
        this.contractPaymentRate = contractPaymentRate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
}
