package com.ejianc.business.oa.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 人力行政-人事晋升审批表
 * 
 * @author generator
 * 
 */
public class EmployeeUpVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 编号
    private Long employeeId; // 员工名称
    private String name; // 员工名称
    private Long orgId; // 区域ID
    private String orgName; // 区域
    private Long deptId; // 部门ID
    private String deptName; // 部门
    private Long postId; // 岗位ID
    private String postName; // 岗位
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date intoDate; // 入职日期
    private Integer rank; // 层级
    private String rankName; // 层级
    private Long newPostId; // 晋升岗位
    private String newPostName; // 晋升岗位
    private Integer newRank; // 晋升层级
    private String newRankName; // 晋升层级
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date useDate; // 生效日期
    private Integer salaryFlag; // 薪资是否异动
    private String salaryFlagName; // 薪资是否异动
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="bfyj-employee-info")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDeptId() {
        return deptId;
    }
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    @ReferSerialTransfer(referCode="idm_post")
    public Long getPostId() {
        return postId;
    }
    @ReferDeserialTransfer
    public void setPostId(Long postId) {
        this.postId = postId;
    }
    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }
    public Date getIntoDate() {
        return intoDate;
    }

    public void setIntoDate(Date intoDate) {
        this.intoDate = intoDate;
    }
    public Integer getRank() {
        return rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }
    public String getRankName() {
        return rankName;
    }

    public void setRankName(String rankName) {
        this.rankName = rankName;
    }
    @ReferSerialTransfer(referCode="idm_post")
    public Long getNewPostId() {
        return newPostId;
    }
    @ReferDeserialTransfer
    public void setNewPostId(Long newPostId) {
        this.newPostId = newPostId;
    }
    public String getNewPostName() {
        return newPostName;
    }

    public void setNewPostName(String newPostName) {
        this.newPostName = newPostName;
    }
    public Integer getNewRank() {
        return newRank;
    }

    public void setNewRank(Integer newRank) {
        this.newRank = newRank;
    }
    public String getNewRankName() {
        return newRankName;
    }

    public void setNewRankName(String newRankName) {
        this.newRankName = newRankName;
    }
    public Date getUseDate() {
        return useDate;
    }

    public void setUseDate(Date useDate) {
        this.useDate = useDate;
    }

    public Integer getSalaryFlag() {
        return salaryFlag;
    }

    public void setSalaryFlag(Integer salaryFlag) {
        this.salaryFlag = salaryFlag;
    }

    public String getSalaryFlagName() {
        return salaryFlagName;
    }

    public void setSalaryFlagName(String salaryFlagName) {
        this.salaryFlagName = salaryFlagName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
