package com.ejianc.business.oa.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 人力行政-退費申请表
 * 
 * @author generator
 * 
 */
public class BackFeeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 编号
    private String projectCode; // 项目编号
    private Long projectId; // 项目名称
    private String projectName; // 项目名称
    private Long orgId; // 区域ID
    private String orgName; // 区域
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date registrationDate; // 项目报名时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date openTenderDate; // 项目开标时间
    private BigDecimal biddingControlMmy; // 控制价(万元)
    private Long provinceId; // 项目所属省份
    private String provinceName; // 项目所属省份
    private Long followPersonId; // 业务经理
    private String followPerson; // 业务经理
    private String registrationFlag; // 是否计入报名个数
    private BigDecimal followPersonMmy; // 业务经理提成
    private BigDecimal documenterMmy; // 资料员提成
    private BigDecimal authMmy; // 授权人提成
    private BigDecimal qualificationMmy; // 应收资质费
    private BigDecimal qualificationBackMmy; // 资质退费金额
    private BigDecimal bidDocMny; // 标书费用
    private BigDecimal bidDocBackMny; // 标书退费金额
    private BigDecimal backMny; // 退费总金额
    private String accountName; // 收款账户
    private String accountNum; // 卡号
    private String memo; // 退费详细说明
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    @ReferSerialTransfer(referCode="bfyj-bid-projectRegistration")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Date getRegistrationDate() {
        return registrationDate;
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }
    public Date getOpenTenderDate() {
        return openTenderDate;
    }

    public void setOpenTenderDate(Date openTenderDate) {
        this.openTenderDate = openTenderDate;
    }
    public BigDecimal getBiddingControlMmy() {
        return biddingControlMmy;
    }

    public void setBiddingControlMmy(BigDecimal biddingControlMmy) {
        this.biddingControlMmy = biddingControlMmy;
    }
    @ReferSerialTransfer(referCode = "bfyj-bid-area")
    public Long getProvinceId() {
        return provinceId;
    }
    @ReferDeserialTransfer
    public void setProvinceId(Long provinceId) {
        this.provinceId = provinceId;
    }
    public String getProvinceName() {
        return provinceName;
    }

    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getFollowPersonId() {
        return followPersonId;
    }
    @ReferDeserialTransfer
    public void setFollowPersonId(Long followPersonId) {
        this.followPersonId = followPersonId;
    }
    public String getFollowPerson() {
        return followPerson;
    }

    public void setFollowPerson(String followPerson) {
        this.followPerson = followPerson;
    }
    public String getRegistrationFlag() {
        return registrationFlag;
    }

    public void setRegistrationFlag(String registrationFlag) {
        this.registrationFlag = registrationFlag;
    }
    public BigDecimal getFollowPersonMmy() {
        return followPersonMmy;
    }

    public void setFollowPersonMmy(BigDecimal followPersonMmy) {
        this.followPersonMmy = followPersonMmy;
    }
    public BigDecimal getDocumenterMmy() {
        return documenterMmy;
    }

    public void setDocumenterMmy(BigDecimal documenterMmy) {
        this.documenterMmy = documenterMmy;
    }
    public BigDecimal getAuthMmy() {
        return authMmy;
    }

    public void setAuthMmy(BigDecimal authMmy) {
        this.authMmy = authMmy;
    }
    public BigDecimal getQualificationMmy() {
        return qualificationMmy;
    }

    public void setQualificationMmy(BigDecimal qualificationMmy) {
        this.qualificationMmy = qualificationMmy;
    }
    public BigDecimal getQualificationBackMmy() {
        return qualificationBackMmy;
    }

    public void setQualificationBackMmy(BigDecimal qualificationBackMmy) {
        this.qualificationBackMmy = qualificationBackMmy;
    }
    public BigDecimal getBidDocMny() {
        return bidDocMny;
    }

    public void setBidDocMny(BigDecimal bidDocMny) {
        this.bidDocMny = bidDocMny;
    }
    public BigDecimal getBidDocBackMny() {
        return bidDocBackMny;
    }

    public void setBidDocBackMny(BigDecimal bidDocBackMny) {
        this.bidDocBackMny = bidDocBackMny;
    }
    public BigDecimal getBackMny() {
        return backMny;
    }

    public void setBackMny(BigDecimal backMny) {
        this.backMny = backMny;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
