package com.ejianc.business.oa.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 人力行政-资产入库单子表
 * 
 * @author generator
 * 
 */
public class InstoreDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long instoreId; // 入库单主表id
    private Long storeId; // 仓库id
    private String storeName; // 仓库名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date instoreDate; // 入库日期
    private Long materialCategoryId; // 物资分类id
    private String materialCategoryName; // 物资分类名称
    private Long materialId; // 物资id
    private String materialCode; // 物资编码
    private String materialName; // 物资名称
    private String materialSpec; // 规格型号
    private String materialUnit; // 计量单位
    private BigDecimal instoreNumber; // 入库数量
    private BigDecimal residueNumber; // 剩可用数量
    private BigDecimal unitPrice; // 单价
    private BigDecimal taxRate; // 税率
    private BigDecimal amount; // 金额
    private String remark; // 备注
    private Long sourceId; // 调拨单子表id
    private String sourceType; // 来源 0-新增 1-档案 2-调拨单生成
    /**
     * 库存可用数量(用于实时计算，不存数据库)
     */
    private BigDecimal canUseNumber;
    private BigDecimal nowNum; // 现存库存数量
    private Long orgId; // 组织
    private String orgName; // 组织名称
    public BigDecimal getNowNum() {
        return nowNum;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public void setNowNum(BigDecimal nowNum) {
        this.nowNum = nowNum;
    }
    public BigDecimal getCanUseNumber() {
        return canUseNumber;
    }

    public void setCanUseNumber(BigDecimal canUseNumber) {
        this.canUseNumber = canUseNumber;
    }

    public Long getInstoreId() {
        return instoreId;
    }

    public void setInstoreId(Long instoreId) {
        this.instoreId = instoreId;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Date getInstoreDate() {
        return instoreDate;
    }

    public void setInstoreDate(Date instoreDate) {
        this.instoreDate = instoreDate;
    }
    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }
    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getMaterialSpec() {
        return materialSpec;
    }

    public void setMaterialSpec(String materialSpec) {
        this.materialSpec = materialSpec;
    }
    public String getMaterialUnit() {
        return materialUnit;
    }

    public void setMaterialUnit(String materialUnit) {
        this.materialUnit = materialUnit;
    }
    public BigDecimal getInstoreNumber() {
        return instoreNumber;
    }

    public void setInstoreNumber(BigDecimal instoreNumber) {
        this.instoreNumber = instoreNumber;
    }
    public BigDecimal getResidueNumber() {
        return residueNumber;
    }

    public void setResidueNumber(BigDecimal residueNumber) {
        this.residueNumber = residueNumber;
    }
    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }
    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
}
