package com.ejianc.business.bid.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 投标管理-投标保证金
 * 
 * @author generator
 * 
 */
public class TenderFundsVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    public static final String 保证金状态_未缴 = "未缴";
    public static final String 保证金状态_已缴 = "已缴";
    public static final String 保证金状态_可退 = "可退";
    public static final String 保证金状态_已退 = "已退";

    private String billCode; // 编码
    private Long registrationId; // 项目报名表Id
    private Long opportunityId; // 商机登记表Id
    private Long opportunityBillCode; // 商机登记单据编码
    private String engineeringName; // 工程名称
    private String recAccName; // 收款账户户名
    private String recAccBankName; // 收款账户银行及开户行
    private String recAcc; // 收款账号
    private BigDecimal mny; // 金额
    private Long employeeId; // 编制人id
    private String employeeName; // 编制人名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date paymentEndDate; // 截至缴纳时间
    private String payAccName; // 打款人户名
    private String payAcc; // 打款人账号
    private String memo; // 备注
    private String boundsStatus; // 状态: 未缴/已缴/可退/已退
    private Integer billState; // 单据状态
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date effectiveDate; // 生效日期
    private Long orgId; // 所属组织Id
    private String orgCode; // 所属组织编码
    private String orgName; // 所属组织名称

    private Long fundsBackId; //保证金退还单Id 为0时表示未被引用

    private Long recAccId; // 收款账户
    private Long accountRegisterId; // 公司付款账户
    private String accountName; // 公司付款账户名称
    private String accountNum; // 公司付款银行账号
    private String accountBank; // 公司付款开户行
    private BigDecimal backMny; // 返还金额
    private String feeType; // 费用类型
    private Long documenterId; // 资料员id
    private String documenterName; // 资料员名称
    public String getFeeType() {
        return feeType;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getDocumenterId() {
        return documenterId;
    }

    @ReferDeserialTransfer
    public void setDocumenterId(Long documenterId) {
        this.documenterId = documenterId;
    }

    public String getDocumenterName() {
        return documenterName;
    }

    public void setDocumenterName(String documenterName) {
        this.documenterName = documenterName;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }
    @ReferSerialTransfer(referCode = "bfyj-account-register")
    public Long getRecAccId() {
        return recAccId;
    }

    @ReferDeserialTransfer
    public void setRecAccId(Long recAccId) {
        this.recAccId = recAccId;
    }

    @ReferSerialTransfer(referCode = "bfyj-account-register")
    public Long getAccountRegisterId() {
        return accountRegisterId;
    }

    @ReferDeserialTransfer
    public void setAccountRegisterId(Long accountRegisterId) {
        this.accountRegisterId = accountRegisterId;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }

    public BigDecimal getBackMny() {
        return backMny;
    }

    public void setBackMny(BigDecimal backMny) {
        this.backMny = backMny;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getFundsBackId() {
        return fundsBackId;
    }

    public void setFundsBackId(Long fundsBackId) {
        this.fundsBackId = fundsBackId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "bfyj-bid-projectRegistration")
    public Long getRegistrationId() {
        return registrationId;
    }
    @ReferDeserialTransfer
    public void setRegistrationId(Long registrationId) {
        this.registrationId = registrationId;
    }
    @ReferSerialTransfer(referCode = "bfyj-bid-busOpportunity")
    public Long getOpportunityId() {
        return opportunityId;
    }
    @ReferDeserialTransfer
    public void setOpportunityId(Long opportunityId) {
        this.opportunityId = opportunityId;
    }
    public Long getOpportunityBillCode() {
        return opportunityBillCode;
    }

    public void setOpportunityBillCode(Long opportunityBillCode) {
        this.opportunityBillCode = opportunityBillCode;
    }
    public String getEngineeringName() {
        return engineeringName;
    }

    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }
    public String getRecAccName() {
        return recAccName;
    }

    public void setRecAccName(String recAccName) {
        this.recAccName = recAccName;
    }
    public String getRecAccBankName() {
        return recAccBankName;
    }

    public void setRecAccBankName(String recAccBankName) {
        this.recAccBankName = recAccBankName;
    }
    public String getRecAcc() {
        return recAcc;
    }

    public void setRecAcc(String recAcc) {
        this.recAcc = recAcc;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getPaymentEndDate() {
        return paymentEndDate;
    }

    public void setPaymentEndDate(Date paymentEndDate) {
        this.paymentEndDate = paymentEndDate;
    }
    public String getPayAccName() {
        return payAccName;
    }

    public void setPayAccName(String payAccName) {
        this.payAccName = payAccName;
    }
    public String getPayAcc() {
        return payAcc;
    }

    public void setPayAcc(String payAcc) {
        this.payAcc = payAcc;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getBoundsStatus() {
        return boundsStatus;
    }

    public void setBoundsStatus(String boundsStatus) {
        this.boundsStatus = boundsStatus;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    
}
