package com.ejianc.business.finance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 出纳资金-零星付款申请
 * 
 * @author generator
 * 
 */
public class PaySporadicVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    private String memo; // 付款事由
    private Integer contractType; // 费用类型：1-分包,2-设备,3-物资采购,4-其他支出合同
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 项目所属组织
    private String parentOrgCode; // 项目所属组织编码
    private String parentOrgName; // 项目所属组织名称
    private String projectType; // 是否属于项目 1-项目，2-公司
    private String projectTypeName; // 是否属于项目 1-项目，2-公司
    private Integer payType; // 支付类型：1-运营支出,2-项目支出,3-往来款
    private Long twoCategoryId; // 二级分类
    private String twoCategoryName; // 二级分类名称
    private Long supplyId; // 供应商
    private String supplyCode; // 供应商编码
    private String supplyName; // 供应商名称
    private BigDecimal applyMny; // 申请金额
    private String bankAccount; // 对方账户
    private String bankName; // 对方开户行
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyDate; // 申请日期
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private BigDecimal payMny; // 支付金额
    private BigDecimal unPayMny; // 未支付金额
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime; // 支付时间
    private String billStateName;
    private String contractTypeName;
    private List<PayRecordVO> payRecordList = new ArrayList<>();//支付记录

    private Long customerId; // 甲方ID
    private String customerName; // 甲方名称
    private Long supplierId; // 乙方ID
    private String supplierName; // 乙方名称
    private BigDecimal prouseTaxMny; // 项目可用资金
    private String accountName; // 对方账户户名
    private Long bearDeptId; // 费用承担部门
    private String bearDept; // 费用承担部门
    private Long payUnitId; // 付款单位
    private String payUnitName; // 付款单位
    private String applyMnyCn; // 申请金额大写
    private List<PaySporadicDetailVO> detailList = new ArrayList<>();

    public List<PaySporadicDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<PaySporadicDetailVO> detailList) {
        this.detailList = detailList;
    }

    @ReferSerialTransfer(referCode="idm-dept")
    public Long getBearDeptId() {
        return bearDeptId;
    }
    @ReferDeserialTransfer
    public void setBearDeptId(Long bearDeptId) {
        this.bearDeptId = bearDeptId;
    }

    public String getBearDept() {
        return bearDept;
    }

    public void setBearDept(String bearDept) {
        this.bearDept = bearDept;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPayUnitId() {
        return payUnitId;
    }
    @ReferDeserialTransfer
    public void setPayUnitId(Long payUnitId) {
        this.payUnitId = payUnitId;
    }

    public String getPayUnitName() {
        return payUnitName;
    }

    public void setPayUnitName(String payUnitName) {
        this.payUnitName = payUnitName;
    }

    public String getApplyMnyCn() {
        return applyMnyCn;
    }

    public void setApplyMnyCn(String applyMnyCn) {
        this.applyMnyCn = applyMnyCn;
    }

    @ReferSerialTransfer(referCode="support-customer")
    public Long getCustomerId() {
        return customerId;
    }

    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public BigDecimal getProuseTaxMny() {
        return prouseTaxMny;
    }

    public void setProuseTaxMny(BigDecimal prouseTaxMny) {
        this.prouseTaxMny = prouseTaxMny;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public List<PayRecordVO> getPayRecordList() {
        return payRecordList;
    }

    public void setPayRecordList(List<PayRecordVO> payRecordList) {
        this.payRecordList = payRecordList;
    }
    public String getContractTypeName() {
        return contractTypeName;
    }

    public void setContractTypeName(String contractTypeName) {
        this.contractTypeName = contractTypeName;
    }
    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }
    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public BigDecimal getUnPayMny() {
        return unPayMny;
    }

    public void setUnPayMny(BigDecimal unPayMny) {
        this.unPayMny = unPayMny;
    }


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }
    @ReferSerialTransfer(referCode = "bfyj-market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }
    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }
    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }
    @ReferSerialTransfer(referCode = "bfyj-categorydoc")
    public Long getTwoCategoryId() {
        return twoCategoryId;
    }
    @ReferDeserialTransfer

    public void setTwoCategoryId(Long twoCategoryId) {
        this.twoCategoryId = twoCategoryId;
    }
    public String getTwoCategoryName() {
        return twoCategoryName;
    }

    public void setTwoCategoryName(String twoCategoryName) {
        this.twoCategoryName = twoCategoryName;
    }
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplyId() {
        return supplyId;
    }
    @ReferDeserialTransfer
    public void setSupplyId(Long supplyId) {
        this.supplyId = supplyId;
    }
    public String getSupplyCode() {
        return supplyCode;
    }

    public void setSupplyCode(String supplyCode) {
        this.supplyCode = supplyCode;
    }
    public String getSupplyName() {
        return supplyName;
    }

    public void setSupplyName(String supplyName) {
        this.supplyName = supplyName;
    }
    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    
}
