package com.ejianc.business.oa.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.finance.vo.PayRecordVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 人力行政-证书人员延续申请表
 * 
 * @author generator
 * 
 */
public class CertKeepVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long humanPayId; // 姓名id
    private String humanPayName; // 姓名
    private Integer sex; // 性别 1：男 2：女
    private Long orgId; // 组织ID
    private String orgName; // 组织
    private String idCard; // 身份证号码
    private Long deptId; // 部门ID
    private String deptName; // 部门
    private Long postId; // 岗位ID
    private String postName; // 岗位
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 证书结束时间
    private String cert; // 原证书情况
    private String certName; // 原证书情况
    private String newCert; // 新证书情况
    private String newCertName; // 新证书情况
    private BigDecimal certMny; // 原证书费用
    private BigDecimal newCertMny; // 新证书费用
    private Integer payType; // 原付款方式
    private String payTypeName; // 原付款方式
    private Integer newPayType; // 新付款方式
    private String newPayTypeName; // 新付款方式
    private Integer insuredFlag; // 是否缴纳保险
    private String insuredFlagName; // 是否缴纳保险
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date insuredEndDate; // 保险结束时间
    private String insuredType; // 保险种类
    private String insuredTypeName; // 保险种类
    private String memo; // 备注
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中

    private String province; // 省份
    private BigDecimal payMny; // 支付金额
    private BigDecimal unPayMny; // 未支付金额
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime; // 支付时间
    private List<PayRecordVO> payRecordList = new ArrayList<>();//支付记录

    public List<PayRecordVO> getPayRecordList() {
        return payRecordList;
    }

    public void setPayRecordList(List<PayRecordVO> payRecordList) {
        this.payRecordList = payRecordList;
    }
    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public BigDecimal getUnPayMny() {
        return unPayMny;
    }

    public void setUnPayMny(BigDecimal unPayMny) {
        this.unPayMny = unPayMny;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }
    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "bfyj-cert-human")
    public Long getHumanPayId() {
        return humanPayId;
    }
    @ReferDeserialTransfer
    public void setHumanPayId(Long humanPayId) {
        this.humanPayId = humanPayId;
    }
    public String getHumanPayName() {
        return humanPayName;
    }

    public void setHumanPayName(String humanPayName) {
        this.humanPayName = humanPayName;
    }
    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }
    @ReferSerialTransfer(referCode="idm-dept")
    public Long getDeptId() {
        return deptId;
    }
    @ReferDeserialTransfer
    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    @ReferSerialTransfer(referCode="idm_post")
    public Long getPostId() {
        return postId;
    }
    @ReferDeserialTransfer
    public void setPostId(Long postId) {
        this.postId = postId;
    }
    public String getPostName() {
        return postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getCert() {
        return cert;
    }
    @ReferDeserialTransfer
    public void setCert(String cert) {
        this.cert = cert;
    }
    public String getCertName() {
        return certName;
    }

    public void setCertName(String certName) {
        this.certName = certName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getNewCert() {
        return newCert;
    }
    @ReferDeserialTransfer
    public void setNewCert(String newCert) {
        this.newCert = newCert;
    }
    public String getNewCertName() {
        return newCertName;
    }

    public void setNewCertName(String newCertName) {
        this.newCertName = newCertName;
    }
    public BigDecimal getCertMny() {
        return certMny;
    }

    public void setCertMny(BigDecimal certMny) {
        this.certMny = certMny;
    }
    public BigDecimal getNewCertMny() {
        return newCertMny;
    }

    public void setNewCertMny(BigDecimal newCertMny) {
        this.newCertMny = newCertMny;
    }
    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }
    public String getPayTypeName() {
        return payTypeName;
    }

    public void setPayTypeName(String payTypeName) {
        this.payTypeName = payTypeName;
    }
    public Integer getNewPayType() {
        return newPayType;
    }

    public void setNewPayType(Integer newPayType) {
        this.newPayType = newPayType;
    }
    public String getNewPayTypeName() {
        return newPayTypeName;
    }

    public void setNewPayTypeName(String newPayTypeName) {
        this.newPayTypeName = newPayTypeName;
    }
    public Integer getInsuredFlag() {
        return insuredFlag;
    }

    public void setInsuredFlag(Integer insuredFlag) {
        this.insuredFlag = insuredFlag;
    }
    public String getInsuredFlagName() {
        return insuredFlagName;
    }

    public void setInsuredFlagName(String insuredFlagName) {
        this.insuredFlagName = insuredFlagName;
    }
    public Date getInsuredEndDate() {
        return insuredEndDate;
    }

    public void setInsuredEndDate(Date insuredEndDate) {
        this.insuredEndDate = insuredEndDate;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getInsuredType() {
        return insuredType;
    }
    @ReferDeserialTransfer
    public void setInsuredType(String insuredType) {
        this.insuredType = insuredType;
    }
    public String getInsuredTypeName() {
        return insuredTypeName;
    }

    public void setInsuredTypeName(String insuredTypeName) {
        this.insuredTypeName = insuredTypeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
}
