package com.ejianc.business.bid.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.finance.vo.PayRecordVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 投标管理-中标服务费
 * 
 * @author generator
 * 
 */
public class BidServiceFeeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 编码
    private Long registrationId; // 项目报名表Id
    private Long opportunityId; // 商机登记表Id
    private Long opportunityBillCode; // 商机登记单据编码
    private String engineeringName; // 项目名称
    private BigDecimal payMny; // 付款金额
    private String payAccountName; // 付款账户名
    private String payAccount; // 付款卡号
    private String payAccountOpenBankName; // 付款开户行
    private String transferPerson; // 转款人
    private String transferAccount; // 转款账号
    private String memo; // 转款备注
    private Integer billState; // 单据状态
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    private Date effectiveDate; // 生效日期
    private Long orgId; // 所属组织id
    private String orgCode; // 所属组织编码
    private String orgName; // 所属组织名称

    private Long employeeId; // 编制人id
    private String employeeName; // 编制人名称
    private String feeType; // 费用类型
    private BigDecimal payMnyRecord; // 支付金额
    private BigDecimal unPayMny; // 未支付金额
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime; // 支付时间
    private List<PayRecordVO> payRecordList = new ArrayList<>();//支付记录

    public List<PayRecordVO> getPayRecordList() {
        return payRecordList;
    }

    public void setPayRecordList(List<PayRecordVO> payRecordList) {
        this.payRecordList = payRecordList;
    }
    public BigDecimal getPayMnyRecord() {
        return payMnyRecord;
    }

    public void setPayMnyRecord(BigDecimal payMnyRecord) {
        this.payMnyRecord = payMnyRecord;
    }

    public BigDecimal getUnPayMny() {
        return unPayMny;
    }

    public void setUnPayMny(BigDecimal unPayMny) {
        this.unPayMny = unPayMny;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }
    public String getFeeType() {
        return feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "bfyj-bid-projectRegistration")
    public Long getRegistrationId() {
        return registrationId;
    }
    @ReferDeserialTransfer
    public void setRegistrationId(Long registrationId) {
        this.registrationId = registrationId;
    }
    @ReferSerialTransfer(referCode = "bfyj-bid-busOpportunity")
    public Long getOpportunityId() {
        return opportunityId;
    }
    @ReferDeserialTransfer
    public void setOpportunityId(Long opportunityId) {
        this.opportunityId = opportunityId;
    }
    public Long getOpportunityBillCode() {
        return opportunityBillCode;
    }

    public void setOpportunityBillCode(Long opportunityBillCode) {
        this.opportunityBillCode = opportunityBillCode;
    }
    public String getEngineeringName() {
        return engineeringName;
    }

    public void setEngineeringName(String engineeringName) {
        this.engineeringName = engineeringName;
    }
    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }
    public String getPayAccountName() {
        return payAccountName;
    }

    public void setPayAccountName(String payAccountName) {
        this.payAccountName = payAccountName;
    }
    public String getPayAccount() {
        return payAccount;
    }

    public void setPayAccount(String payAccount) {
        this.payAccount = payAccount;
    }
    public String getPayAccountOpenBankName() {
        return payAccountOpenBankName;
    }

    public void setPayAccountOpenBankName(String payAccountOpenBankName) {
        this.payAccountOpenBankName = payAccountOpenBankName;
    }

    public String getTransferPerson() {
        return transferPerson;
    }

    public void setTransferPerson(String transferPerson) {
        this.transferPerson = transferPerson;
    }

    public String getTransferAccount() {
        return transferAccount;
    }

    public void setTransferAccount(String transferAccount) {
        this.transferAccount = transferAccount;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    
}
