package com.ejianc.business.oa.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.business.finance.vo.PayRecordVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.oa.vo.CertSalaryDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 人力行政-证书人员工资表
 * 
 * @author generator
 * 
 */
public class CertSalaryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date month; // 月份
    private BigDecimal allSalaryMny; // 应发工资总额
    private BigDecimal allActualSalaryMny; // 实发工资总额
    private String memo; // 备注
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime; // 经办时间

    private String billStateName;
    private String type; //1内部，2外部
    private BigDecimal payMny; // 支付金额
    private BigDecimal unPayMny; // 未支付金额
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTimeRecord; // 支付时间
    private List<PayRecordVO> payRecordList = new ArrayList<>();//支付记录

    public List<PayRecordVO> getPayRecordList() {
        return payRecordList;
    }

    public void setPayRecordList(List<PayRecordVO> payRecordList) {
        this.payRecordList = payRecordList;
    }
    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public BigDecimal getUnPayMny() {
        return unPayMny;
    }

    public void setUnPayMny(BigDecimal unPayMny) {
        this.unPayMny = unPayMny;
    }

    public Date getConfirmTimeRecord() {
        return confirmTimeRecord;
    }

    public void setConfirmTimeRecord(Date confirmTimeRecord) {
        this.confirmTimeRecord = confirmTimeRecord;
    }

    private List<CertSalaryDetailVO> detailList = new ArrayList<>(); // 人力行政-证书人员工资表子表

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }
    public BigDecimal getAllSalaryMny() {
        return allSalaryMny;
    }

    public void setAllSalaryMny(BigDecimal allSalaryMny) {
        this.allSalaryMny = allSalaryMny;
    }
    public BigDecimal getAllActualSalaryMny() {
        return allActualSalaryMny;
    }

    public void setAllActualSalaryMny(BigDecimal allActualSalaryMny) {
        this.allActualSalaryMny = allActualSalaryMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public List<CertSalaryDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<CertSalaryDetailVO> detailList) {
        this.detailList = detailList;
    }

}
