package com.ejianc.business.tax.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 税务管理-收票登记
 * 
 * @author generator
 * 
 */
public class InvoiceReceiveRegistVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String code; // 单据编号
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long orgId; // 组织id
    private String orgName; // 组织名称
    private String orgCode; // 组织编码
    private Long parentOrgId; // 项目所属组织
    private String parentOrgName; // 项目所属组织名称
    private String parentOrgCode; // 项目所属组织编码
    private Integer receiveType; // 业务类型：1自缴异地预缴2/项目异地预缴票
    private Long projectId; // 项目id
    private String projectName; // 项目名称
//    private Long buyerId; // 购方id
//    private String buyerName; // 购方名称
    private BigDecimal contractMnyTax; // 合同金额
    private Long sellerId; // 供应商id
    private String sellerName; // 供应商名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date registDate; // 收票登记日期
    private String memo; // 备注
    private Long processPersonId; // 经办人id
    private String processPersonName; // 经办人名称
    private BigDecimal totalReceiveMnyTax; // 累计收票金额含税
    private BigDecimal totalReceiveMnyTaxNoHave; // 累计收票金额不含本次
    private BigDecimal currentReceiveMnyTax; // 本次收票金额含税
    private BigDecimal currentReceiveMny; // 本次收票金额不含税
    private BigDecimal taxMny; // 税金
    private Long projectBillId; // 项目对账单id
    private String receiveTypeName; // 业务类型：1自缴异地预缴2/项目异地预缴票
    private Integer passBoolean; // 子表是否含有合格发票(1-是，0否)
    private Integer projectFlag; // 是否项目收票(1-是，0否)
    private List<InvoiceReceivePoolVO> invoiceReceivePoolList = new ArrayList<>(); // 税务管理-收票登记-详情
    private BigDecimal sumPayMny; // 累计付款

    private Long contractId; // 合同主键
    private String contractName; // 合同名称
    private String contractCode; // 合同编码
    private Integer contractType; // 合同类型：1-分包,2-设备,3-物资采购,4-其他支出合同


    @ReferSerialTransfer(referCode = "bfyj-Contract")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }
    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public String getReceiveTypeName() {
        return receiveTypeName;
    }

    public void setReceiveTypeName(String receiveTypeName) {
        this.receiveTypeName = receiveTypeName;
    }

    public Integer getPassBoolean() {
        return passBoolean;
    }

    public void setPassBoolean(Integer passBoolean) {
        this.passBoolean = passBoolean;
    }

    public Integer getProjectFlag() {
        return projectFlag;
    }

    public void setProjectFlag(Integer projectFlag) {
        this.projectFlag = projectFlag;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Integer getReceiveType() {
        return receiveType;
    }

    public void setReceiveType(Integer receiveType) {
        this.receiveType = receiveType;
    }
    @ReferSerialTransfer(referCode="bfyj-market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
//    @ReferSerialTransfer(referCode="support-customer")
//    public Long getBuyerId() {
//        return buyerId;
//    }
//    @ReferDeserialTransfer
//    public void setBuyerId(Long buyerId) {
//        this.buyerId = buyerId;
//    }
//    public String getBuyerName() {
//        return buyerName;
//    }
//
//    public void setBuyerName(String buyerName) {
//        this.buyerName = buyerName;
//    }
    public BigDecimal getContractMnyTax() {
        return contractMnyTax;
    }

    public void setContractMnyTax(BigDecimal contractMnyTax) {
        this.contractMnyTax = contractMnyTax;
    }
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSellerId() {
        return sellerId;
    }
    @ReferDeserialTransfer
    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }
    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }
    public Date getRegistDate() {
        return registDate;
    }

    public void setRegistDate(Date registDate) {
        this.registDate = registDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getProcessPersonId() {
        return processPersonId;
    }
    @ReferDeserialTransfer
    public void setProcessPersonId(Long processPersonId) {
        this.processPersonId = processPersonId;
    }
    public String getProcessPersonName() {
        return processPersonName;
    }

    public void setProcessPersonName(String processPersonName) {
        this.processPersonName = processPersonName;
    }
    public BigDecimal getTotalReceiveMnyTax() {
        return totalReceiveMnyTax;
    }

    public void setTotalReceiveMnyTax(BigDecimal totalReceiveMnyTax) {
        this.totalReceiveMnyTax = totalReceiveMnyTax;
    }

    public BigDecimal getTotalReceiveMnyTaxNoHave() {
        return totalReceiveMnyTaxNoHave;
    }

    public void setTotalReceiveMnyTaxNoHave(BigDecimal totalReceiveMnyTaxNoHave) {
        this.totalReceiveMnyTaxNoHave = totalReceiveMnyTaxNoHave;
    }

    public BigDecimal getCurrentReceiveMnyTax() {
        return currentReceiveMnyTax;
    }

    public void setCurrentReceiveMnyTax(BigDecimal currentReceiveMnyTax) {
        this.currentReceiveMnyTax = currentReceiveMnyTax;
    }
    public BigDecimal getCurrentReceiveMny() {
        return currentReceiveMny;
    }

    public void setCurrentReceiveMny(BigDecimal currentReceiveMny) {
        this.currentReceiveMny = currentReceiveMny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public Long getProjectBillId() {
        return projectBillId;
    }

    public void setProjectBillId(Long projectBillId) {
        this.projectBillId = projectBillId;
    }
    
     public List<InvoiceReceivePoolVO> getInvoiceReceivePoolList() {
        return invoiceReceivePoolList;
     }

     public void setInvoiceReceivePoolList(List<InvoiceReceivePoolVO> invoiceReceivePoolList) {
        this.invoiceReceivePoolList = invoiceReceivePoolList;
     }
}
