package com.ejianc.business.bid.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 投标管理-月度费用提成申请
 * 
 * @author generator
 * 
 */
public class MonthFeeApplyVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String createUserName; // 创建人名称
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date monthDate; // 月份
    private Long employeeId; // 人员Id
    private String employeeName; // 人员名称
    private Long orgId; // 人员所属组织Id
    private String orgName; // 人员所属组织名称
    private BigDecimal mny; // 费用提成明细
    private String memo; // 备注
    private String billCode; // 单据编号
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    private List<MonthFeeApplyDetailVO> monthFeeApplyDetailList = new ArrayList<>(); // 投标管理-月度费用提成申请详情
    private BigDecimal payMny; // 支付金额
    private BigDecimal unPayMny; // 未支付金额
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime; // 支付时间

    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public BigDecimal getUnPayMny() {
        return unPayMny;
    }

    public void setUnPayMny(BigDecimal unPayMny) {
        this.unPayMny = unPayMny;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public Date getMonthDate() {
        return monthDate;
    }

    public void setMonthDate(Date monthDate) {
        this.monthDate = monthDate;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
     public List<MonthFeeApplyDetailVO> getMonthFeeApplyDetailList() {
        return monthFeeApplyDetailList;
     }

     public void setMonthFeeApplyDetailList(List<MonthFeeApplyDetailVO> monthFeeApplyDetailList) {
        this.monthFeeApplyDetailList = monthFeeApplyDetailList;
     }
}
