package com.ejianc.business.asset.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 资产管理-投资收益
 * 
 * @author generator
 * 
 */
public class InvestIncomeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 上级组织
    private String parentOrgCode; // 上级组织编码
    private String parentOrgName; // 上级组织名称
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long receiveKind; // 收入类型
    private String receiveKindName; // 收入类型名称
    private Long receiveWay; // 收款方式
    private String receiveWayName; // 收款方式名称
    private BigDecimal receiveMny; // 收款金额
    private BigDecimal sumCollectMny; // 累计收款金额(不含本期)
    private BigDecimal sumCollectHaveThisMny; // 累计收款金额(含本期)
    private BigDecimal invoiceMny; // 开票金额
    private BigDecimal sumInvoicingMny; // 累计开票金额
    private String receiveExplain; // 收款说明
    private String accountName; // 账户名
    private String bankAccount; // 银行账号
    private String bankName; // 开户行
    private String memo; // 备注
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime; // 经办时间

    private String billStateName;

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    @ReferSerialTransfer(referCode="asset-project-approval")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode="bfyj-receive-type")
    public Long getReceiveKind() {
        return receiveKind;
    }
    @ReferDeserialTransfer
    public void setReceiveKind(Long receiveKind) {
        this.receiveKind = receiveKind;
    }
    public String getReceiveKindName() {
        return receiveKindName;
    }

    public void setReceiveKindName(String receiveKindName) {
        this.receiveKindName = receiveKindName;
    }
    public Long getReceiveWay() {
        return receiveWay;
    }

    public void setReceiveWay(Long receiveWay) {
        this.receiveWay = receiveWay;
    }
    public String getReceiveWayName() {
        return receiveWayName;
    }

    public void setReceiveWayName(String receiveWayName) {
        this.receiveWayName = receiveWayName;
    }
    public BigDecimal getReceiveMny() {
        return receiveMny;
    }

    public void setReceiveMny(BigDecimal receiveMny) {
        this.receiveMny = receiveMny;
    }
    public BigDecimal getSumCollectMny() {
        return sumCollectMny;
    }

    public void setSumCollectMny(BigDecimal sumCollectMny) {
        this.sumCollectMny = sumCollectMny;
    }
    public BigDecimal getSumCollectHaveThisMny() {
        return sumCollectHaveThisMny;
    }

    public void setSumCollectHaveThisMny(BigDecimal sumCollectHaveThisMny) {
        this.sumCollectHaveThisMny = sumCollectHaveThisMny;
    }
    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }
    public BigDecimal getSumInvoicingMny() {
        return sumInvoicingMny;
    }

    public void setSumInvoicingMny(BigDecimal sumInvoicingMny) {
        this.sumInvoicingMny = sumInvoicingMny;
    }
    public String getReceiveExplain() {
        return receiveExplain;
    }

    public void setReceiveExplain(String receiveExplain) {
        this.receiveExplain = receiveExplain;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }
    
}
