package com.ejianc.business.finance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 出纳资金-支付记录
 * 
 * @author generator
 * 
 */
public class PayRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String applyBillCode; // 单据编号
    private Long payapplyId; // 付款申请主键
    private String applyType; // 付款申请类型：合同付款,零星采购,民工工资,证书费用
    private String projectType; // 是否属于项目 1-项目，2-公司
    private Long contractId; // 合同主键
    private String contractName; // 合同名称
    private Integer contractType; // 合同类型：1-分包,2-设备,3-物资采购,4-其他支出合同
    private Long projectId; // 项目Id
    private String projectName; // 项目名称
    private Long orgId; // 项目部Id
    private String orgName; // 项目部名称
    private String orgCode; // 项目部编码
    private Long parentOrgId; // 项目部上级组织Id
    private String parentOrgName; // 项目部上级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private Integer payType; // 支付类型：1-运营支出,2-项目支出,3-往来款
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyDate; // 申请日期
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private BigDecimal payMny; // 支付金额
    private BigDecimal applyMny; // 申请金额
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime; // 经办时间
    private Date approveTime; // 审批时间
    private BigDecimal thisPayMny; // 本期支付金额
    private Long payWay; // 付款方式
    private String payWayName; // 付款方式名称
    private Long accountRegisterId; // 账户
    private String accountName; // 账户名称
    private String accountNum; // 银行账号
    private String accountBank; // 开户行
    private String memo; // 备注
    

    public String getApplyBillCode() {
        return applyBillCode;
    }

    public void setApplyBillCode(String applyBillCode) {
        this.applyBillCode = applyBillCode;
    }
    public Long getPayapplyId() {
        return payapplyId;
    }

    public void setPayapplyId(Long payapplyId) {
        this.payapplyId = payapplyId;
    }
    public String getApplyType() {
        return applyType;
    }

    public void setApplyType(String applyType) {
        this.applyType = applyType;
    }
    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }
    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }
    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }
    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }
    public BigDecimal getThisPayMny() {
        return thisPayMny;
    }

    public void setThisPayMny(BigDecimal thisPayMny) {
        this.thisPayMny = thisPayMny;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPayWay() {
        return payWay;
    }
    @ReferDeserialTransfer
    public void setPayWay(Long payWay) {
        this.payWay = payWay;
    }
    public String getPayWayName() {
        return payWayName;
    }

    public void setPayWayName(String payWayName) {
        this.payWayName = payWayName;
    }
    @ReferSerialTransfer(referCode = "bfyj-account-register")
    public Long getAccountRegisterId() {
        return accountRegisterId;
    }
    @ReferDeserialTransfer
    public void setAccountRegisterId(Long accountRegisterId) {
        this.accountRegisterId = accountRegisterId;
    }
    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }
    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }
    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
