package com.ejianc.business.finance.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 出纳资金-零星付款申请-费用明细
 * 
 * @author generator
 * 
 */
public class PaySporadicDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long pid; // 申请单主键
    private Long oneCategoryId; // 一级分类
    private String oneCategory; // 一级分类
    private BigDecimal feeTaxMny; // 费用金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date feeHappenDate; // 费用发生日期
    private String feeMemo; // 备注
    private Long twoCategoryId; // 二级分类
    private String twoCategory; // 二级分类
    

    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    @ReferSerialTransfer(referCode="bfyj-finDoc-self")
    public Long getOneCategoryId() {
        return oneCategoryId;
    }
    @ReferDeserialTransfer
    public void setOneCategoryId(Long oneCategoryId) {
        this.oneCategoryId = oneCategoryId;
    }
    public String getOneCategory() {
        return oneCategory;
    }

    public void setOneCategory(String oneCategory) {
        this.oneCategory = oneCategory;
    }
    public BigDecimal getFeeTaxMny() {
        return feeTaxMny;
    }

    public void setFeeTaxMny(BigDecimal feeTaxMny) {
        this.feeTaxMny = feeTaxMny;
    }
    public Date getFeeHappenDate() {
        return feeHappenDate;
    }

    public void setFeeHappenDate(Date feeHappenDate) {
        this.feeHappenDate = feeHappenDate;
    }
    public String getFeeMemo() {
        return feeMemo;
    }

    public void setFeeMemo(String feeMemo) {
        this.feeMemo = feeMemo;
    }
    @ReferSerialTransfer(referCode="bfyj-categorydoc")
    public Long getTwoCategoryId() {
        return twoCategoryId;
    }
    @ReferDeserialTransfer
    public void setTwoCategoryId(Long twoCategoryId) {
        this.twoCategoryId = twoCategoryId;
    }
    public String getTwoCategory() {
        return twoCategory;
    }

    public void setTwoCategory(String twoCategory) {
        this.twoCategory = twoCategory;
    }
    
}
