package com.ejianc.business.oa.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 油卡使用明细
 * 
 * @author generator
 * 
 */
public class OilUseVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private BigDecimal mny; // 加油金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date time; // 加油时间
    private String rechargePeople; // 加油经办人
    private String operatePeople; // 操作经办人
    private String memo; // 备注
    private Long pid; // 主表ID

    private String car; // 加油车辆
    private String ccMemo1; // 抄送内容
    private Long useCcPeopleId; // 抄送人
    private String useCcPeopleName; // 抄送人名称
    private String useCcPeopleCode; // 抄送人编码
    @ReferSerialTransfer(referCode = "idm-user")
    public Long getUseCcPeopleId() {
        return useCcPeopleId;
    }
    @ReferDeserialTransfer
    public void setUseCcPeopleId(Long useCcPeopleId) {
        this.useCcPeopleId = useCcPeopleId;
    }

    public String getUseCcPeopleName() {
        return useCcPeopleName;
    }

    public void setUseCcPeopleName(String useCcPeopleName) {
        this.useCcPeopleName = useCcPeopleName;
    }

    public String getUseCcPeopleCode() {
        return useCcPeopleCode;
    }

    public void setUseCcPeopleCode(String useCcPeopleCode) {
        this.useCcPeopleCode = useCcPeopleCode;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }
    public Date getTime() {
        return time;
    }

    public void setTime(Date time) {
        this.time = time;
    }
    public String getRechargePeople() {
        return rechargePeople;
    }

    public void setRechargePeople(String rechargePeople) {
        this.rechargePeople = rechargePeople;
    }
    public String getOperatePeople() {
        return operatePeople;
    }

    public void setOperatePeople(String operatePeople) {
        this.operatePeople = operatePeople;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getPid() {
        return pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }
    public String getCar() {
        return car;
    }

    public void setCar(String car) {
        this.car = car;
    }
    public String getCcMemo1() {
        return ccMemo1;
    }

    public void setCcMemo1(String ccMemo1) {
        this.ccMemo1 = ccMemo1;
    }

    
}
