package com.ejianc.business.finance.utils;

import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.MapUtils;

import java.math.BigDecimal;
import java.util.Map;

/**
 * @description: 对传过来的param进行加工处理
 * @author songlx
 * @date 2022/11/2
 * @version 1.0
 */
public class ParamSearchUtil {


    //支付时间字段名
    public static final String CONFIRM_TIME = "confirmTime";

    //支付状态字段名
    public static final String PAY_STATUS = "payStatus";

    /**
     * @description: 支出管理- 特殊查询参数处理
     * 1、根据列表筛选项【支付时间】confirmTime查询时，传的是日期，数据库存的是年月日时分秒，导致between查询没有后包含的问题修复
     * 2、支付状态已完成的处理
     * @param param
     * @return
     * @author songlx
     * @date: 2022/11/2
     */
    public static void handleQueryParam(QueryParam param) {
        Map<String, Parameter> params = param.getParams();
        if (MapUtils.isNotEmpty(params) && params.containsKey(CONFIRM_TIME)) {
            Parameter parameter = params.get(CONFIRM_TIME);
            Object valueObj = parameter.getValue();
            if (valueObj != null) {
                String[] strArr = String.valueOf(valueObj).split(",|，");
                if (strArr != null && strArr.length == 2) {
                    String newConfirmTime = strArr[0] + " 00:00:00," + strArr[1] + " 23:59:59";
                    parameter.setValue(newConfirmTime);
                }
            }
        }

        if (MapUtils.isNotEmpty(params) && params.containsKey(PAY_STATUS)) {
            Parameter parameter = params.get(PAY_STATUS);
            Object valueObj = parameter.getValue();
            //支付状态已完成：付款金额 = 申请金额
            if (valueObj != null && "3".equals(String.valueOf(valueObj))) {
                param.getParams().put("sql", new Parameter(QueryParam.SQL, " pay_mny = apply_mny "));
                params.remove(PAY_STATUS);
            }
        }

    }
}
