package com.ejianc.business.finance.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.business.finance.vo.ReceiveInvoiceVO;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@TableName("ejc_finance_receive")
public class ReceiveEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 单据编号
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 收入属性
     */
    @TableField("receive_type")
    private Long receiveType;
    /**
     * 收入类型
     */
    @TableField("receive_kind")
    private Long receiveKind;

    public Long getReceiveKind() {
        return receiveKind;
    }

    public void setReceiveKind(Long receiveKind) {
        this.receiveKind = receiveKind;
    }


    public String getReceiveKindName() {
        return receiveKindName;
    }

    public void setReceiveKindName(String receiveKindName) {
        this.receiveKindName = receiveKindName;
    }

    /**
     * 收入类型名称
     */
    @TableField("receive_kind_name")
    private String receiveKindName;

    /**
     * 合同主键
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 合同编码
     */
    @TableField("contract_code")
    private String contractCode;

    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    /**
     * 项目
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 项目类型：1-自营，2-联营
     */
    @TableField("project_type")
    private String projectType;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 收款方式
     */
    @TableField("receive_way")
    private Long receiveWay;

    @TableField("receive_way_name")
    private String receiveWayName;


    /**
     * 收款金额
     */
    @TableField("receive_mny")
    private BigDecimal receiveMny;

    /**
     * 收款单位
     */
    @TableField("receive_unit_id")
    private Long receiveUnitId;

    /**
     * 收款单位名称
     */
    @TableField("receive_unit_name")
    private String receiveUnitName;

    /**
     * 收款说明
     */
    @TableField("receive_explain")
    private String receiveExplain;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 经办时间
     */
    @TableField("confirm_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime;

    /**
     * 合同金额
     */
    @TableField("contract_mny")
    private BigDecimal contractMny;

    /**
     * 累计产值
     */
    @TableField("sum_production_mny")
    private BigDecimal sumProductionMny;

    /**
     * 累计批量
     */
    @TableField("sum_quote_mny")
    private BigDecimal sumQuoteMny;

    /**
     * 累计收款金额(不含本期)
     */
    @TableField("sum_collect_mny")
    private BigDecimal sumCollectMny;

    /**
     * 累计收款金额(含本期)
     */
    @TableField(value="sum_collect_have_this_mny")
    private BigDecimal sumCollectHaveThisMny;

    /**
     * 累计开票金额
     */
    @TableField("sum_invoicing_mny")
    private BigDecimal sumInvoicingMny;

    /**
     * 开票金额
     */
    @TableField("invoice_mny")
    private BigDecimal invoiceMny;

    /**
     * 收款类型：1-组织收款 2-项目收款
     */
    @TableField("pay_type")
    private Integer payType;


    @TableField(value="account_name")
    private java.lang.String accountName; // 账户名
    @TableField(value="bank_account")
    private java.lang.String bankAccount; // 银行账号
    @TableField(value="bank_name")
    private java.lang.String bankName; // 开户行


    @TableField(value="account_id")
    private Long accountId; // 收款账户

    public String getReceiveWayName() {
        return receiveWayName;
    }

    public void setReceiveWayName(String receiveWayName) {
        this.receiveWayName = receiveWayName;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public BigDecimal getSumCollectHaveThisMny() {
        return sumCollectHaveThisMny;
    }

    public void setSumCollectHaveThisMny(BigDecimal sumCollectHaveThisMny) {
        this.sumCollectHaveThisMny = sumCollectHaveThisMny;
    }

    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getReceiveType() {
        return receiveType;
    }

    public void setReceiveType(Long receiveType) {
        this.receiveType = receiveType;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getReceiveWay() {
        return receiveWay;
    }

    public void setReceiveWay(Long receiveWay) {
        this.receiveWay = receiveWay;
    }

    public BigDecimal getReceiveMny() {
        return receiveMny;
    }

    public void setReceiveMny(BigDecimal receiveMny) {
        this.receiveMny = receiveMny;
    }

    public Long getReceiveUnitId() {
        return receiveUnitId;
    }

    public void setReceiveUnitId(Long receiveUnitId) {
        this.receiveUnitId = receiveUnitId;
    }

    public String getReceiveUnitName() {
        return receiveUnitName;
    }

    public void setReceiveUnitName(String receiveUnitName) {
        this.receiveUnitName = receiveUnitName;
    }

    public String getReceiveExplain() {
        return receiveExplain;
    }

    public void setReceiveExplain(String receiveExplain) {
        this.receiveExplain = receiveExplain;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }

    public BigDecimal getSumQuoteMny() {
        return sumQuoteMny;
    }

    public void setSumQuoteMny(BigDecimal sumQuoteMny) {
        this.sumQuoteMny = sumQuoteMny;
    }

    public BigDecimal getSumCollectMny() {
        return sumCollectMny;
    }

    public void setSumCollectMny(BigDecimal sumCollectMny) {
        this.sumCollectMny = sumCollectMny;
    }

    public BigDecimal getSumInvoicingMny() {
        return sumInvoicingMny;
    }

    public void setSumInvoicingMny(BigDecimal sumInvoicingMny) {
        this.sumInvoicingMny = sumInvoicingMny;
    }

    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }

}
