package com.ejianc.business.invest.service.impl;

import com.ejianc.business.invest.service.IProjectRepaymentService;
import com.ejianc.business.invest.vo.ProjectDebtVO;
import com.ejianc.business.invest.vo.ProjectRepaymentVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.invest.mapper.ProjectDebtMapper;
import com.ejianc.business.invest.bean.ProjectDebtEntity;
import com.ejianc.business.invest.service.IProjectDebtService;

/**
 * 项目投资-项目借款
 * 
 * @author generator
 * 
 */
@Service("projectDebtService")
public class ProjectDebtServiceImpl extends BaseServiceImpl<ProjectDebtMapper, ProjectDebtEntity> implements IProjectDebtService{
    @Autowired
    private IProjectRepaymentService projectRepaymentService;

    @Override
    public ProjectDebtVO queryProjectDebtData(Long projectId) {
        ProjectDebtVO projectDebtVO = new ProjectDebtVO();
        ProjectRepaymentVO projectRepaymentVO = projectRepaymentService.queryProjectDebt(projectId);

        if (null != projectRepaymentVO){
            projectDebtVO.setTotalDebtMny(projectRepaymentVO.getTotalDebtMny());
            projectDebtVO.setTotalDebtResidueMny(projectRepaymentVO.getTotalDebtResidueMny());
            projectDebtVO.setTotalRepaymentMny(projectRepaymentVO.getTotalRepaymentMny());
        }
        return projectDebtVO;
    }
}
