package com.ejianc.business.tax.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.tax.bean.InvoiceReceivePoolEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 税务管理-收票登记
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tax_invoice_receive_regist")
public class InvoiceReceiveRegistEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="code")
    private String code; // 单据编号
    @TableField(value="name")
    private String name; // 单据名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目所属组织
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目所属组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目所属组织编码
    @TableField(value="receive_type")
    private Integer receiveType; // 业务类型：1自缴异地预缴2/项目异地预缴票
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="buyer_id")
    private Long buyerId; // 购方id
    @TableField(value="buyer_name")
    private String buyerName; // 购方名称
    @TableField(value="contract_mny_tax")
    private BigDecimal contractMnyTax; // 合同金额
    @TableField(value="seller_id")
    private Long sellerId; // 销售方id
    @TableField(value="seller_name")
    private String sellerName; // 销售方名称
    @TableField(value="regist_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date registDate; // 收票登记日期
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="process_person_id")
    private Long processPersonId; // 经办人id
    @TableField(value="process_person_name")
    private String processPersonName; // 经办人名称
    @TableField(value="total_receive_mny_tax")
    private BigDecimal totalReceiveMnyTax; // 累计收票金额含税
    @TableField(value="total_receive_mny")
    private BigDecimal totalReceiveMny; // 累计收票金额不含税
    @TableField(value="current_receive_mny_tax")
    private BigDecimal currentReceiveMnyTax; // 本次收票金额含税
    @TableField(value="current_receive_mny")
    private BigDecimal currentReceiveMny; // 本次收票金额不含税
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 税金
    @TableField(value="project_bill_id")
    private Long projectBillId; // 项目对账单id
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="invoiceReceivePoolService",pidName = "receiveBillId")
    private List<InvoiceReceivePoolEntity> invoiceReceivePoolList = new ArrayList<>(); // 税务管理-收票登记-详情
    

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Integer getReceiveType() {
        return receiveType;
    }

    public void setReceiveType(Integer receiveType) {
        this.receiveType = receiveType;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getBuyerId() {
        return buyerId;
    }

    public void setBuyerId(Long buyerId) {
        this.buyerId = buyerId;
    }
    public String getBuyerName() {
        return buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }
    public BigDecimal getContractMnyTax() {
        return contractMnyTax;
    }

    public void setContractMnyTax(BigDecimal contractMnyTax) {
        this.contractMnyTax = contractMnyTax;
    }
    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }
    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }
    public Date getRegistDate() {
        return registDate;
    }

    public void setRegistDate(Date registDate) {
        this.registDate = registDate;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getProcessPersonId() {
        return processPersonId;
    }

    public void setProcessPersonId(Long processPersonId) {
        this.processPersonId = processPersonId;
    }
    public String getProcessPersonName() {
        return processPersonName;
    }

    public void setProcessPersonName(String processPersonName) {
        this.processPersonName = processPersonName;
    }
    public BigDecimal getTotalReceiveMnyTax() {
        return totalReceiveMnyTax;
    }

    public void setTotalReceiveMnyTax(BigDecimal totalReceiveMnyTax) {
        this.totalReceiveMnyTax = totalReceiveMnyTax;
    }
    public BigDecimal getTotalReceiveMny() {
        return totalReceiveMny;
    }

    public void setTotalReceiveMny(BigDecimal totalReceiveMny) {
        this.totalReceiveMny = totalReceiveMny;
    }
    public BigDecimal getCurrentReceiveMnyTax() {
        return currentReceiveMnyTax;
    }

    public void setCurrentReceiveMnyTax(BigDecimal currentReceiveMnyTax) {
        this.currentReceiveMnyTax = currentReceiveMnyTax;
    }
    public BigDecimal getCurrentReceiveMny() {
        return currentReceiveMny;
    }

    public void setCurrentReceiveMny(BigDecimal currentReceiveMny) {
        this.currentReceiveMny = currentReceiveMny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public Long getProjectBillId() {
        return projectBillId;
    }

    public void setProjectBillId(Long projectBillId) {
        this.projectBillId = projectBillId;
    }
    

    public List<InvoiceReceivePoolEntity> getInvoiceReceivePoolList() {
        return invoiceReceivePoolList;
    }

    public void setInvoiceReceivePoolList(List<InvoiceReceivePoolEntity> invoiceReceivePoolList) {
        this.invoiceReceivePoolList = invoiceReceivePoolList;
    }
}
