package com.ejianc.business.cost.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.cost.bean.OtherFeeEntity;
import com.ejianc.business.cost.service.IOtherFeeService;
import com.ejianc.business.cost.vo.OtherFeeVO;
import com.ejianc.business.cost.vo.ProjectBillVO;
import com.ejianc.business.finance.bean.PayMigrantEntity;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.finance.service.IPayMigrantService;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.tax.bean.InvoiceOpenRegistEntity;
import com.ejianc.business.tax.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.tax.bean.InvoiceReceiveRegistEntity;
import com.ejianc.business.tax.service.IInvoiceOpenRegistService;
import com.ejianc.business.tax.service.IInvoiceReceivePoolService;
import com.ejianc.business.tax.service.IInvoiceReceiveRegistService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.cost.mapper.ProjectBillMapper;
import com.ejianc.business.cost.bean.ProjectBillEntity;
import com.ejianc.business.cost.service.IProjectBillService;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 成本会计-项目对账单
 * 
 * @author generator
 * 
 */
@Service("projectBillService")
public class ProjectBillServiceImpl extends BaseServiceImpl<ProjectBillMapper, ProjectBillEntity> implements IProjectBillService{

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOtherFeeService otherFeeService;
    @Autowired
    private IInvoiceReceiveRegistService invoiceReceiveRegistService;
    @Autowired
    private IInvoiceReceivePoolService invoiceReceivePoolService;
    @Autowired
    private IReceiveService receiveService;
    @Autowired
    private IPayMigrantService payMigrantService;
    @Autowired
    private IInvoiceOpenRegistService invoiceOpenRegistService;


    private static final String BILL_CODE = "BFYJ_CBKJ_QTFY";//此处需要根据实际修改

    @Override
    public ProjectBillVO insertOrUpdate(ProjectBillVO saveOrUpdateVO) {
        ProjectBillEntity entity = BeanMapper.map(saveOrUpdateVO, ProjectBillEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setId(IdWorker.getId());



            //绑定收票登记
            if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getInvoiceReceiveRegisterIdList()) && saveOrUpdateVO.getInvoiceReceiveRegisterIdList().size() > 0){
                invoiceReceiveRegistService.update(new UpdateWrapper<InvoiceReceiveRegistEntity>().in("id", saveOrUpdateVO.getInvoiceReceiveRegisterIdList()).set("project_bill_id", entity.getId()));
            }
            //绑定开票登记
            if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getInvoiceOpenRegistIdList()) && saveOrUpdateVO.getInvoiceOpenRegistIdList().size() > 0){
                invoiceOpenRegistService.update(new UpdateWrapper<InvoiceOpenRegistEntity>().in("id", saveOrUpdateVO.getInvoiceOpenRegistIdList()).set("project_bill_id", entity.getId()));
            }
            //绑定收款登记
            if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getReceiveIdList()) && saveOrUpdateVO.getReceiveIdList().size() > 0){
                receiveService.update(new UpdateWrapper<ReceiveEntity>().in("id", saveOrUpdateVO.getReceiveIdList()).set("project_bill_id", entity.getId()));
            }
            //绑定民工工资收款
            if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getPayMigrantIdList()) && saveOrUpdateVO.getPayMigrantIdList().size() > 0){
                payMigrantService.update(new UpdateWrapper<PayMigrantEntity>().in("id", saveOrUpdateVO.getPayMigrantIdList()).set("project_bill_id", entity.getId()));
            }
            //绑定其他费用单
            if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getOtherFeeIdList()) && saveOrUpdateVO.getOtherFeeIdList().size() > 0){
                otherFeeService.update(new UpdateWrapper<OtherFeeEntity>().in("id", saveOrUpdateVO.getOtherFeeIdList()).set("project_bill_id", entity.getId()));
            }
        }
        super.saveOrUpdate(entity, false);
        ProjectBillVO vo = BeanMapper.map(super.selectById(entity.getId()), ProjectBillVO.class);
        return vo;
    }

    @Override
    public ProjectBillVO queryProjectBillDataByProjectId(String projectId) {
        ProjectBillVO projectBillVO = new ProjectBillVO();
        //1、占用收票
        //标记合格的收票登记，且未被项目对账单引用过得
//        todo：查询 合格的收票登记
        // 统计业务类型为 项目异地预缴 的收票登记 智取一个值 异地预缴税额
//        .eq("receive_type", 2)
        List<InvoiceReceiveRegistEntity> invoiceReceiveRegisterList = invoiceReceiveRegistService.list(new QueryWrapper<InvoiceReceiveRegistEntity>().in("bill_state", Arrays.asList(1, 3)).eq("pass_boolean", 1).eq("project_id", projectId).isNull("project_bill_id"));
        if (CollectionUtils.isNotEmpty(invoiceReceiveRegisterList) && invoiceReceiveRegisterList.size() > 0){
            //占用收票赋值
            List<Long> invoiceReceiveRegisterIdList = invoiceReceiveRegisterList.stream().map(InvoiceReceiveRegistEntity::getId).collect(Collectors.toList());
            projectBillVO.setInvoiceReceiveRegisterIdList(invoiceReceiveRegisterIdList);

            //查对应的收票登记-子表
            List<InvoiceReceivePoolEntity> invoiceReceivePoolList = invoiceReceivePoolService.list(new QueryWrapper<InvoiceReceivePoolEntity>().in("receive_bill_id", invoiceReceiveRegisterIdList));

            //查到合格的发票
            List<InvoiceReceivePoolEntity> passList = invoiceReceivePoolList.stream().filter(p -> p.getPassFlag() != null && 1 == p.getPassFlag()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(passList) && passList.size() > 0){
                //异地预缴税额
                projectBillVO.setDifPlaceAdvanceTax(passList.stream().filter(p -> p.getTaxMny() != null).map(InvoiceReceivePoolEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                //新增可抵扣税额（专票-自定义档案id：1853691016918339586）
                projectBillVO.setDeductTax(passList.stream().filter(p -> p.getTaxMny() != null && null != p.getInvoiceType() &&  "1853691016918339586".equals(String.valueOf(p.getInvoiceType()))).map(InvoiceReceivePoolEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                //新增专票成本
                projectBillVO.setSpecialTicketCost(passList.stream().filter(p -> p.getInvoiceTaxMny() != null && null != p.getInvoiceType() &&  "1853691016918339586".equals(String.valueOf(p.getInvoiceType()))).map(InvoiceReceivePoolEntity::getInvoiceTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                //新增普票成本（普票-自定义档案id：1853691041769590785）
                projectBillVO.setCommonTicketMny(passList.stream().filter(p -> p.getInvoiceTaxMny() != null && null != p.getInvoiceType() &&  "1853691041769590785".equals(String.valueOf(p.getInvoiceType()))).map(InvoiceReceivePoolEntity::getInvoiceTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
            //不合格的发票
            List<InvoiceReceivePoolEntity> noPassList = invoiceReceivePoolList.stream().filter(p -> p.getTaxMny() != null && 0 == p.getPassFlag()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(noPassList) && noPassList.size() > 0){
                //待合格成本
                projectBillVO.setWaitPassCost(noPassList.stream().filter(p -> p.getInvoiceTaxMny() != null).map(InvoiceReceivePoolEntity::getInvoiceTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
        }

        //2、占用开票
        List<InvoiceOpenRegistEntity> openRegisterList = invoiceOpenRegistService.list(new QueryWrapper<InvoiceOpenRegistEntity>().in("bill_state", Arrays.asList(1, 3)).eq("project_id", projectId));
        if (CollectionUtils.isNotEmpty(openRegisterList) && openRegisterList.size() > 0){
            //累计开票金额
            projectBillVO.setTotalInvoiceMny(openRegisterList.stream().filter(p -> p.getOpenMny() != null).map(InvoiceOpenRegistEntity::getOpenMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            List<InvoiceOpenRegistEntity> noQuoteList = openRegisterList.stream().filter(p -> p.getProjectBillId() == null).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(noQuoteList) && noQuoteList.size() > 0){
                projectBillVO.setInvoiceOpenRegistIdList(noQuoteList.stream().map(InvoiceOpenRegistEntity::getId).collect(Collectors.toList()));
                //本次开票额
                projectBillVO.setInvoiceMny(noQuoteList.stream().filter(p -> p.getOpenMny() != null).map(InvoiceOpenRegistEntity::getOpenMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
        }


        //2、收款登记单
        // 查收款类型为已交税金-1850783141581557761L、合同收款-1850783094378860546L
        List<ReceiveEntity> allReceiveList = receiveService.list(new QueryWrapper<ReceiveEntity>().in("bill_state", Arrays.asList(1, 3)).eq("project_id", projectId).in("receive_kind", Arrays.asList(1850783094378860546L,1850783141581557761L)));
        if (CollectionUtils.isNotEmpty(allReceiveList) && allReceiveList.size() > 0){
            //累计回款金额
            projectBillVO.setTotalPaymentMny(allReceiveList.stream().filter(p -> p.getReceiveMny() != null && null != p.getReceiveKind() && "1850783094378860546".equals(String.valueOf(p.getReceiveKind()))).map(ReceiveEntity::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            //todo:计费依据?

            //查出未被引用的收款登记单
            List<ReceiveEntity> receiveList = allReceiveList.stream().filter(p -> p.getProjectBillId() == null).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(receiveList) && receiveList.size() > 0){
                projectBillVO.setReceiveIdList(receiveList.stream().map(ReceiveEntity::getId).collect(Collectors.toList()));
                //本次回款金额
                projectBillVO.setRepaymentMny(receiveList.stream().filter(p -> p.getReceiveMny() != null && null != p.getReceiveKind() && "1850783094378860546".equals(String.valueOf(p.getReceiveKind()))).map(ReceiveEntity::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                //已交税金
                projectBillVO.setAlreadyPayTax(receiveList.stream().filter(p -> p.getReceiveMny() != null && null != p.getReceiveKind() && "1850783141581557761".equals(String.valueOf(p.getReceiveKind()))).map(ReceiveEntity::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
        }

        //3、民工工资支付申请记录
        List<PayMigrantEntity> payMigrantList = payMigrantService.list(new QueryWrapper<PayMigrantEntity>().in("bill_state", Arrays.asList(1, 3)).eq("project_id", projectId).gt("pay_mny", BigDecimal.ZERO).isNull("project_bill_id"));
        if (CollectionUtils.isNotEmpty(payMigrantList) && payMigrantList.size() > 0){
            projectBillVO.setPayMigrantIdList(payMigrantList.stream().map(PayMigrantEntity::getId).collect(Collectors.toList()));
            //新增农民工工资成本
            projectBillVO.setMigrantWorkerCashCost(payMigrantList.stream().filter(p -> p.getPayMny() != null).map(PayMigrantEntity::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        }

        //4、其他费用单
        List<OtherFeeEntity> otherFeeList = otherFeeService.list(new QueryWrapper<OtherFeeEntity>().in("bill_state", Arrays.asList(1, 3)).eq("project_id", projectId).isNull("project_bill_id"));
        if (CollectionUtils.isNotEmpty(otherFeeList) && otherFeeList.size() > 0){
            projectBillVO.setOtherFeeIdList(otherFeeList.stream().map(OtherFeeEntity::getId).collect(Collectors.toList()));
            projectBillVO.setOtherChargeableMny(otherFeeList.stream().filter(p -> p.getFeeMny() != null).map(OtherFeeEntity::getFeeMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        return projectBillVO;
    }

    @Override
    public void removeDataByProjectBillId(Long id) {
        otherFeeService.update(new UpdateWrapper<OtherFeeEntity>().in("project_bill_id", id).set("project_bill_id", null));
        invoiceReceiveRegistService.update(new UpdateWrapper<InvoiceReceiveRegistEntity>().in("project_bill_id", id).set("project_bill_id", null));
        receiveService.update(new UpdateWrapper<ReceiveEntity>().in("project_bill_id", id).set("project_bill_id", null));
        payMigrantService.update(new UpdateWrapper<PayMigrantEntity>().in("project_bill_id", id).set("project_bill_id", null));
        invoiceOpenRegistService.update(new UpdateWrapper<InvoiceOpenRegistEntity>().in("project_bill_id", id).set("project_bill_id", null));
    }
}
