/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.cost.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.cost.bean.OtherFeeEntity;
import com.ejianc.business.cost.bean.ProjectBillEntity;
import com.ejianc.business.cost.mapper.ProjectBillMapper;
import com.ejianc.business.cost.service.IOtherFeeService;
import com.ejianc.business.cost.service.IProjectBillService;
import com.ejianc.business.cost.vo.ProjectBillVO;
import com.ejianc.business.finance.bean.PayMigrantEntity;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.finance.service.IPayMigrantService;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.tax.bean.InvoiceOpenRegistEntity;
import com.ejianc.business.tax.bean.InvoiceReceivePoolEntity;
import com.ejianc.business.tax.service.IInvoiceOpenRegistService;
import com.ejianc.business.tax.service.IInvoiceReceivePoolService;
import com.ejianc.business.tax.service.IInvoiceReceiveRegistService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectBillService")
public class ProjectBillServiceImpl
extends BaseServiceImpl<ProjectBillMapper, ProjectBillEntity>
implements IProjectBillService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOtherFeeService otherFeeService;
    @Autowired
    private IInvoiceReceiveRegistService invoiceReceiveRegistService;
    @Autowired
    private IInvoiceReceivePoolService invoiceReceivePoolService;
    @Autowired
    private IReceiveService receiveService;
    @Autowired
    private IPayMigrantService payMigrantService;
    @Autowired
    private IInvoiceOpenRegistService invoiceOpenRegistService;
    private static final String BILL_CODE = "BFYJ_CBKJ_QTFY";

    @Override
    public ProjectBillVO insertOrUpdate(ProjectBillVO saveOrUpdateVO) {
        ProjectBillEntity entity = (ProjectBillEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ProjectBillEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setId(IdWorker.getId());
            if (CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getInvoiceReceiveRegisterIdList()) && saveOrUpdateVO.getInvoiceReceiveRegisterIdList().size() > 0) {
                this.invoiceReceiveRegistService.update((Wrapper)((UpdateWrapper)new UpdateWrapper().in((Object)"id", (Collection)saveOrUpdateVO.getInvoiceReceiveRegisterIdList())).set((Object)"project_bill_id", (Object)entity.getId()));
            }
            if (CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getInvoiceOpenRegistIdList()) && saveOrUpdateVO.getInvoiceOpenRegistIdList().size() > 0) {
                this.invoiceOpenRegistService.update((Wrapper)((UpdateWrapper)new UpdateWrapper().in((Object)"id", (Collection)saveOrUpdateVO.getInvoiceOpenRegistIdList())).set((Object)"project_bill_id", (Object)entity.getId()));
            }
            if (CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getReceiveIdList()) && saveOrUpdateVO.getReceiveIdList().size() > 0) {
                this.receiveService.update((Wrapper)((UpdateWrapper)new UpdateWrapper().in((Object)"id", (Collection)saveOrUpdateVO.getReceiveIdList())).set((Object)"project_bill_id", (Object)entity.getId()));
            }
            if (CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getPayMigrantIdList()) && saveOrUpdateVO.getPayMigrantIdList().size() > 0) {
                this.payMigrantService.update((Wrapper)((UpdateWrapper)new UpdateWrapper().in((Object)"id", (Collection)saveOrUpdateVO.getPayMigrantIdList())).set((Object)"project_bill_id", (Object)entity.getId()));
            }
            if (CollectionUtils.isNotEmpty((Collection)saveOrUpdateVO.getOtherFeeIdList()) && saveOrUpdateVO.getOtherFeeIdList().size() > 0) {
                this.otherFeeService.update((Wrapper)((UpdateWrapper)new UpdateWrapper().in((Object)"id", (Collection)saveOrUpdateVO.getOtherFeeIdList())).set((Object)"project_bill_id", (Object)entity.getId()));
            }
        }
        super.saveOrUpdate((Object)entity, false);
        ProjectBillVO vo = (ProjectBillVO)BeanMapper.map((Object)super.selectById((Serializable)entity.getId()), ProjectBillVO.class);
        return vo;
    }

    @Override
    public ProjectBillVO queryProjectBillDataByProjectId(String projectId) {
        List otherFeeList;
        List payMigrantList;
        List allReceiveList;
        List openRegisterList;
        ProjectBillVO projectBillVO = new ProjectBillVO();
        List invoiceReceiveRegisterList = this.invoiceReceiveRegistService.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"bill_state", Arrays.asList(1, 3))).eq((Object)"pass_boolean", (Object)1)).eq((Object)"project_id", (Object)projectId)).isNull((Object)"project_bill_id"));
        if (CollectionUtils.isNotEmpty((Collection)invoiceReceiveRegisterList) && invoiceReceiveRegisterList.size() > 0) {
            List noPassList;
            List invoiceReceiveRegisterIdList = invoiceReceiveRegisterList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            projectBillVO.setInvoiceReceiveRegisterIdList(invoiceReceiveRegisterIdList);
            List invoiceReceivePoolList = this.invoiceReceivePoolService.list((Wrapper)new QueryWrapper().in((Object)"receive_bill_id", invoiceReceiveRegisterIdList));
            List passList = invoiceReceivePoolList.stream().filter(p -> p.getPassFlag() != null && 1 == p.getPassFlag()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(passList) && passList.size() > 0) {
                projectBillVO.setDifPlaceAdvanceTax(passList.stream().filter(p -> p.getTaxMny() != null).map(InvoiceReceivePoolEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                projectBillVO.setDeductTax(passList.stream().filter(p -> p.getTaxMny() != null && null != p.getInvoiceType() && "1853691016918339586".equals(String.valueOf(p.getInvoiceType()))).map(InvoiceReceivePoolEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                projectBillVO.setSpecialTicketCost(passList.stream().filter(p -> p.getInvoiceTaxMny() != null && null != p.getInvoiceType() && "1853691016918339586".equals(String.valueOf(p.getInvoiceType()))).map(InvoiceReceivePoolEntity::getInvoiceTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                projectBillVO.setCommonTicketMny(passList.stream().filter(p -> p.getInvoiceTaxMny() != null && null != p.getInvoiceType() && "1853691041769590785".equals(String.valueOf(p.getInvoiceType()))).map(InvoiceReceivePoolEntity::getInvoiceTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
            if (CollectionUtils.isNotEmpty(noPassList = invoiceReceivePoolList.stream().filter(p -> p.getTaxMny() != null && 0 == p.getPassFlag()).collect(Collectors.toList())) && noPassList.size() > 0) {
                projectBillVO.setWaitPassCost(noPassList.stream().filter(p -> p.getInvoiceTaxMny() != null).map(InvoiceReceivePoolEntity::getInvoiceTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(openRegisterList = this.invoiceOpenRegistService.list((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"bill_state", Arrays.asList(1, 3))).eq((Object)"project_id", (Object)projectId)))) && openRegisterList.size() > 0) {
            projectBillVO.setTotalInvoiceMny(openRegisterList.stream().filter(p -> p.getOpenMny() != null).map(InvoiceOpenRegistEntity::getOpenMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            List noQuoteList = openRegisterList.stream().filter(p -> p.getProjectBillId() == null).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(noQuoteList) && noQuoteList.size() > 0) {
                projectBillVO.setInvoiceOpenRegistIdList(noQuoteList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
                projectBillVO.setInvoiceMny(noQuoteList.stream().filter(p -> p.getOpenMny() != null).map(InvoiceOpenRegistEntity::getOpenMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(allReceiveList = this.receiveService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"bill_state", Arrays.asList(1, 3))).eq((Object)"project_id", (Object)projectId)).in((Object)"receive_kind", Arrays.asList(1850783094378860546L, 1850783141581557761L))))) && allReceiveList.size() > 0) {
            projectBillVO.setTotalPaymentMny(allReceiveList.stream().filter(p -> p.getReceiveMny() != null && null != p.getReceiveKind() && "1850783094378860546".equals(String.valueOf(p.getReceiveKind()))).map(ReceiveEntity::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            List receiveList = allReceiveList.stream().filter(p -> p.getProjectBillId() == null).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(receiveList) && receiveList.size() > 0) {
                projectBillVO.setReceiveIdList(receiveList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
                projectBillVO.setRepaymentMny(receiveList.stream().filter(p -> p.getReceiveMny() != null && null != p.getReceiveKind() && "1850783094378860546".equals(String.valueOf(p.getReceiveKind()))).map(ReceiveEntity::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                projectBillVO.setAlreadyPayTax(receiveList.stream().filter(p -> p.getReceiveMny() != null && null != p.getReceiveKind() && "1850783141581557761".equals(String.valueOf(p.getReceiveKind()))).map(ReceiveEntity::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(payMigrantList = this.payMigrantService.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"bill_state", Arrays.asList(1, 3))).eq((Object)"project_id", (Object)projectId)).gt((Object)"pay_mny", (Object)BigDecimal.ZERO)).isNull((Object)"project_bill_id")))) && payMigrantList.size() > 0) {
            projectBillVO.setPayMigrantIdList(payMigrantList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            projectBillVO.setMigrantWorkerCashCost(payMigrantList.stream().filter(p -> p.getPayMny() != null).map(PayMigrantEntity::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        if (CollectionUtils.isNotEmpty((Collection)(otherFeeList = this.otherFeeService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"bill_state", Arrays.asList(1, 3))).eq((Object)"project_id", (Object)projectId)).isNull((Object)"project_bill_id")))) && otherFeeList.size() > 0) {
            projectBillVO.setOtherFeeIdList(otherFeeList.stream().map(BaseEntity::getId).collect(Collectors.toList()));
            projectBillVO.setOtherChargeableMny(otherFeeList.stream().filter(p -> p.getFeeMny() != null).map(OtherFeeEntity::getFeeMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        }
        return projectBillVO;
    }

    @Override
    public void removeDataByProjectBillId(Long id) {
        this.otherFeeService.update((Wrapper)((UpdateWrapper)new UpdateWrapper().in((Object)"project_bill_id", new Object[]{id})).set((Object)"project_bill_id", null));
        this.invoiceReceiveRegistService.update((Wrapper)((UpdateWrapper)new UpdateWrapper().in((Object)"project_bill_id", new Object[]{id})).set((Object)"project_bill_id", null));
        this.receiveService.update((Wrapper)((UpdateWrapper)new UpdateWrapper().in((Object)"project_bill_id", new Object[]{id})).set((Object)"project_bill_id", null));
        this.payMigrantService.update((Wrapper)((UpdateWrapper)new UpdateWrapper().in((Object)"project_bill_id", new Object[]{id})).set((Object)"project_bill_id", null));
        this.invoiceOpenRegistService.update((Wrapper)((UpdateWrapper)new UpdateWrapper().in((Object)"project_bill_id", new Object[]{id})).set((Object)"project_bill_id", null));
    }
}

