/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.project.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.project.LeaveSiteVO;
import com.ejianc.business.project.bean.InSiteEntity;
import com.ejianc.business.project.bean.LeaveSiteEntity;
import com.ejianc.business.project.service.IInSiteService;
import com.ejianc.business.project.service.ILeaveSiteService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"leaveSite"})
public class LeaveSiteController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BID_PERSON_LEAVE_SITE";
    @Autowired
    private ILeaveSiteService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IInSiteService inSiteService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    public CommonResponse<LeaveSiteVO> saveOrUpdate(@RequestBody LeaveSiteVO saveOrUpdateVO) {
        LeaveSiteEntity entity = (LeaveSiteEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, LeaveSiteEntity.class));
        InSiteEntity personInSite = (InSiteEntity)((Object)this.inSiteService.selectById(saveOrUpdateVO.getOnSiteId()));
        if (null != personInSite.getRefBillId() && !personInSite.getRefBillId().equals(saveOrUpdateVO.getId())) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5f53\u524d\u4eba\u5458\u6d3e\u9063\u5355\u5df2\u88ab\u64a4\u573a\u5355\u5f15\u7528\uff01");
        }
        LeaveSiteEntity dbEntity = null;
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            entity.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
            entity.setEmployeeName(this.sessionManager.getUserContext().getEmployeeName());
            entity.setId(IdWorker.getId());
            this.inSiteService.updateRefBillId(entity.getOnSiteId(), entity.getId(), false);
        } else {
            dbEntity = (LeaveSiteEntity)((Object)this.service.selectById(entity.getId()));
        }
        if (null != dbEntity && !dbEntity.getOnSiteId().equals(saveOrUpdateVO.getOnSiteId())) {
            this.inSiteService.updateRefBillId(entity.getOnSiteId(), entity.getId(), true);
        }
        this.service.saveOrUpdate((Object)entity, false);
        LeaveSiteVO vo = (LeaveSiteVO)BeanMapper.map((Object)((Object)entity), LeaveSiteVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<LeaveSiteVO> queryDetail(Long id) {
        LeaveSiteEntity entity = (LeaveSiteEntity)((Object)this.service.selectById(id));
        LeaveSiteVO vo = (LeaveSiteVO)BeanMapper.map((Object)((Object)entity), LeaveSiteVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@RequestBody List<LeaveSiteVO> vos) {
        this.service.removeAllByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()));
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<LeaveSiteVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("onSiteEmployeeName");
        fuzzyFields.add("onSitePostName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), LeaveSiteVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("onSiteEmployeeName");
        fuzzyFields.add("onSitePostName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("LeaveSite-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refLeaveSiteData"}, method={RequestMethod.GET})
    public CommonResponse<IPage<LeaveSiteVO>> refLeaveSiteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("onSiteEmployeeName");
        fuzzyFields.add("onSitePostName");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), LeaveSiteVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

