package com.ejianc.business.bid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.bid.bean.BusOpportunityEntity;
import com.ejianc.business.bid.bean.ProjectRegistrationAffirmEntity;
import com.ejianc.business.bid.bean.WinningRegistrationEntity;
import com.ejianc.business.bid.constants.BidCommonContants;
import com.ejianc.business.bid.service.IBusOpportunityService;
import com.ejianc.business.bid.service.IProjectRegistrationAffirmService;
import com.ejianc.business.bid.service.IWinningRegistrationService;
import com.ejianc.business.project.bean.ProjectRegisterEntity;
import com.ejianc.business.project.service.IProjectRegisterService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Service("projectRegistrationAffirm") 
public class ProjectRegistrationAffirmBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IProjectRegistrationAffirmService service;

	@Autowired
	private SessionManager sessionManager;

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IProjectRegisterService projectRegisterService;

	@Autowired
	private IBusOpportunityService busOpportunityService;

	@Autowired
	private IWinningRegistrationService winningRegistrationService;

	@Autowired
	private IOrgApi orgApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		ProjectRegistrationAffirmEntity e = service.selectById(billId);
		e.setCommitDate(new Date());
		e.setCommitUserCode(InvocationInfoProxy.getUsercode());
		e.setCommitUserCode(sessionManager.getUserContext().getUserName());
		service.saveOrUpdate(e, false);
		return CommonResponse.success("提交审批回调处理成功！");
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return doBack(billId, state, billTypeCode);
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批后回调
	 *
	 * @param billId	//单据id
	 * @param state		//单据状态
	 * @param billTypeCode		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	@Override
	public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ProjectRegistrationAffirmEntity e = service.selectById(billId);
		if(BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)) {
			e.setCommitDate(new Date());
			e.setCommitUserCode(InvocationInfoProxy.getUsercode());
			e.setCommitUserCode(sessionManager.getUserContext().getUserName());
		}

		//设置生效时间
		e.setEffectiveDate(new Date());

		//生成项目立项档案
		saveProjectInfo(e);
		
		//更新确认单
		service.saveOrUpdate(e, false);

		return CommonResponse.success("终审审批回调处理成功！");
	}

	private void saveProjectInfo(ProjectRegistrationAffirmEntity e) {
		ProjectRegisterEntity project = new ProjectRegisterEntity();
		//项目报名
		project.setRegistrationId(e.getRegistrationId());
		//商机登记
		project.setOpportunityId(e.getOpportunityId());
		project.setOpportunityBillCode(e.getOpportunityBillCode());
		//确认单
		project.setAffirmId(e.getId());
		project.setAffirmBillCode(e.getBillCode());
		//项目基本信息
		project.setName(e.getEngineeringName());
		project.setShortName(e.getEngineeringName());
		project.setCode(e.getEngineeringCode());
		project.setOrgId(e.getOrgId());
		project.setOrgName(e.getOrgName());
		project.setOrgCode(e.getOrgCode());
		project.setPlannedCommencementDate(e.getPlannedCommencementDate());
		project.setPlannedFinishDate(e.getPlannedFinishDate());

		//查询商机登记信息
		BusOpportunityEntity opportunityEntity = busOpportunityService.selectById(e.getOpportunityId());
		project.setFollowPersonId(opportunityEntity.getFollowPersonId());

		//查询中标登记信息
		List<WinningRegistrationEntity> winList = winningRegistrationService.getByBusOpportunityId(e.getOpportunityId());
		if(CollectionUtils.isNotEmpty(winList)) {
			WinningRegistrationEntity win = winList.get(0);
			//中标金额
			project.setBidMny(win.getBidMny());
			//中标日期
			project.setBidDate(win.getBidDate());
			//发布单位
			project.setPubUnit(win.getPubUnitId());
			project.setPubUnitName(win.getPubUnitName());
		}

		project.setCreateTime(new Date());
		project.setCreateUserCode(e.getCreateUserCode());
		project.setValidStatus(BidCommonContants.STRING_YES); //默认启用
		project.setStatus(BidCommonContants.STRING_YES); //默认未开工
		project.setSyncEsFlag(BidCommonContants.INTEGER_NO);
		project.setDr(BidCommonContants.INTEGER_NO);
		project.setTenantId(e.getTenantId());

		//生成项目部
		OrgVO projectDepartment = generateProjectDepartment(project);
		//保存更新项目部信息
		if(null != projectDepartment) {
			CommonResponse<OrgVO> resp = orgApi.saveOrgInfo(projectDepartment);
			if (!resp.isSuccess()) {
				logger.error("项目确认单id-{}生成项目部信息失败，保存更新对应项目部信息【{}】失败，原因：{}", project.getAffirmId(),
						JSONObject.toJSONString(projectDepartment), JSONObject.toJSONString(resp));
				throw new BusinessException("操作失败，生成项目部信息出错: " + resp.getMsg());
			}
			projectDepartment = resp.getData();
		}

		//设置项目部信息
		project.setProjectDepartmentId(projectDepartment.getId());
		project.setProjectDepartmentCode(projectDepartment.getCode());
		project.setProjectDepartmentName(projectDepartment.getName());

		//保存项目立项档案
		projectRegisterService.saveOrUpdate(project, false);
	}

	private OrgVO generateProjectDepartment(ProjectRegisterEntity project) {
		CommonResponse<OrgVO> response = orgApi.getOneById(project.getOrgId());
		OrgVO parentOrg = null;
		if (!response.isSuccess() || null == response.getData()) {
			logger.error("项目确认单id-{}生成项目部信息失败，获取所属组织id-{}信息为空或失败, {}", project.getAffirmId(), project.getOrgId(), JSONObject.toJSONString(response));
			throw new BusinessException("操作失败，查询项目所属组织信息失败!" );
		}
		parentOrg = response.getData();
		OrgVO projectDepartment = new OrgVO();
		projectDepartment.setId(IdWorker.getId());
		projectDepartment.setParentId(project.getOrgId());
		projectDepartment.setTenantId(parentOrg.getTenantId());
		projectDepartment.setEnterpriseId(parentOrg.getEnterpriseId());
		projectDepartment.setIsParent(false);
		projectDepartment.setName(project.getName());
		projectDepartment.setShortName(project.getName());
		projectDepartment.setState(1);
		//项目部类型
		projectDepartment.setOrgType(OrgVO.ORG_TYPE_DEPARTMENT);

		return projectDepartment;
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return doBack(billId, state, billTypeCode);
	}

	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> doBack(Long billId, Integer state, String billTypeCode) {
		logger.info("项目登记确认单据billId-{}, state-{}, billTypeCode-{}撤回事件处理", billId, state, billTypeCode);

		//查询项目立项档案信息
		ProjectRegisterEntity project =  projectRegisterService.getByAffirmId(billId);

		//查询项目立项是否有已发生下游业务
		CommonResponse<String> checkCommonResponse = billTypeApi.checkQuote(BidCommonContants.BILL_TYPE_PROJECT_RESIGTER, project.getId());
		boolean success = checkCommonResponse.isSuccess();
		if (!success){
			return CommonResponse.error("确认单对应项目立项档案已发生下游业务,不能弃审和撤回");
		}

		//删除项目部信息
		logger.info("执行项目删部除操作，删除项目部[id-{}]", project.getProjectDepartmentId());
		//删除对应项目部相关信息
		CommonResponse<String> delResp = orgApi.delByOrgId(project.getProjectDepartmentId());
		if(!delResp.isSuccess()) {
			logger.error("删除项目确认单[id-{}]对应项目部[id-{}]信息失败，原因：{}", billId, project.getProjectDepartmentId(), delResp.getMsg());
			return CommonResponse.error("操作失败，删除对应项目部信息失败。");
		}
		//删除项目登记信息
		projectRegisterService.removeById(project.getId(), false);

		ProjectRegistrationAffirmEntity e = service.selectById(billId);
		e.setCommitDate(null);
		e.setCommitUserCode(null);
		e.setCommitUserCode(null);
		e.setEffectiveDate(null);
		service.saveOrUpdate(e, false);

		return CommonResponse.success("审批回退回调查成功！");

	}

}
