package com.ejianc.business.invest.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.invest.bean.IncomeDetailEntity;
import com.ejianc.business.invest.service.IIncomeDetailService;
import com.ejianc.business.invest.vo.IncomeYearVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.invest.bean.IncomeEntity;
import com.ejianc.business.invest.service.IIncomeService;
import com.ejianc.business.invest.vo.IncomeVO;

/**
 * 项目投资-投资收益
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("income")
public class IncomeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "BFYJ_XMTZ_TZSY";//此处需要根据实际修改

    @Autowired
    private IIncomeService service;
    @Autowired
    private IIncomeDetailService incomeDetailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IncomeVO> saveOrUpdate(@RequestBody IncomeVO saveOrUpdateVO) {
    	IncomeEntity entity = BeanMapper.map(saveOrUpdateVO, IncomeEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            List<IncomeEntity> incomeEntityList = service.list(new QueryWrapper<IncomeEntity>().eq("month", saveOrUpdateVO.getMonth()));
            if (CollectionUtils.isNotEmpty(incomeEntityList) && incomeEntityList.size() > 0){
                throw new BusinessException("当前月份单据已存在，请切换月份！");
            }
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	IncomeVO vo = BeanMapper.map(entity, IncomeVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IncomeVO> queryDetail(Long id) {
    	IncomeEntity entity = service.selectById(id);
    	IncomeVO vo = BeanMapper.map(entity, IncomeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<IncomeVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (IncomeVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(IncomeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<IncomeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<IncomeEntity> page = service.queryPage(param,false);
        IPage<IncomeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), IncomeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<IncomeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<IncomeVO> voList = BeanMapper.mapList(list, IncomeVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("Income-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refIncomeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<IncomeVO>> refIncomeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<IncomeEntity> page = service.queryPage(param,false);
        IPage<IncomeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), IncomeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }




    /**
     * @Description queryList 查询年度收益
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryIncomeReport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryIncomeReport(@RequestBody QueryParam param) {
        JSONObject page = new JSONObject();
        List<IncomeYearVO> incomeYearVOList = new ArrayList<>();
        String year = "";
        String searchText = param.getSearchText();
        int total = 0;

        if (null != param.getParams().get("year")) {
            year = String.valueOf(param.getParams().get("year").getValue()).substring(0, 4);
            param.getParams().remove("year");
            incomeYearVOList = service.queryIncomeReport(year, searchText);
            total = incomeYearVOList.size();
            if (CollectionUtils.isNotEmpty(incomeYearVOList) && incomeYearVOList.size() > 0){
                incomeYearVOList = incomeYearVOList.stream().skip((param.getPageIndex() - 1) * param.getPageSize())
                        .limit(param.getPageSize()).collect(Collectors.toList());
            }
        }

        page.put("records", incomeYearVOList);
        page.put("total", total);
        page.put("current", param.getPageIndex());
        page.put("size", param.getPageSize());
        page.put("pages", Math.ceil(incomeYearVOList.size() / param.getPageSize()) + 1);
        return CommonResponse.success("查询列表数据成功！", page);
    }


    /**
     * @Description 年度收益报表导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelReportExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelReportExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<IncomeYearVO> incomeYearVOList = new ArrayList<>();
        String year = "";
        String searchText = param.getSearchText();

        if (null != param.getParams().get("year")) {
            year = String.valueOf(param.getParams().get("year").getValue()).substring(0, 4);
            param.getParams().remove("year");
            incomeYearVOList = service.queryIncomeReport(year, searchText);
            if (CollectionUtils.isNotEmpty(incomeYearVOList) && incomeYearVOList.size() > 0){
                incomeYearVOList = incomeYearVOList.stream().skip((param.getPageIndex() - 1) * param.getPageSize())
                        .limit(param.getPageSize()).collect(Collectors.toList());
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", incomeYearVOList);
        ExcelExport.getInstance().export("IncomeYear-export.xlsx", beans, response);
    }

}
