package com.ejianc.business.tax.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 税务管理-开票登记
 * 
 * @author generator
 * 
 */
 @TableName("ejc_tax_invoice_open_regist")
public class InvoiceOpenRegistEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="code")
    private String code; // 开票登记单号
    @TableField(value="apply_code")
    private String applyCode; // 申请单号
    @TableField(value="apply_id")
    private Long applyId; // 申请单id
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目所属组织
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目所属组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目所属组织编码
    @TableField(value="project_bill_id")
    private Long projectBillId; // 项目对账单id
    @TableField(value="buyer_id")
    private Long buyerId; // 购方id（客户档案）
    @TableField(value="buyer_name")
    private String buyerName; // 购方名称
    @TableField(value="project_accounting_id")
    private Long projectAccountingId; // 项目会计
    @TableField(value="project_accounting_name")
    private String projectAccountingName; // 项目会计名称
    @TableField(value="tax_levy_rate")
    private BigDecimal taxLevyRate; // 征收方式
    @TableField(value="actual_open_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date actualOpenDate; // 实际开票日期
    @TableField(value="open_mny")
    private BigDecimal openMny; // 开票额
    @TableField(value="should_receive_tax")
    private BigDecimal shouldReceiveTax; // 应收税额
    @TableField(value="preparement_mny")
    private BigDecimal preparementMny; // 项目自己预缴
    @TableField(value="preparement_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date preparementDate; // 预缴属期
    @TableField(value="wait_tax_mny")
    private BigDecimal waitTaxMny; // 待收税款
    @TableField(value="contractual_model")
    private Long contractualModel; // 承包模式
    @TableField(value="contractual_model_name")
    private String contractualModelName; // 承包模式
    @TableField(value="apply_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate; // 申报日期
    @TableField(value="apply_mny")
    private BigDecimal applyMny; // 申报金额
    @TableField(value="ded_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date dedDate; // 扣除日期
    @TableField(value="ded_mny")
    private BigDecimal dedMny; // 扣除金额
    @TableField(value="supplier_id")
    private Long supplierId; // 分包单位
    @TableField(value="supplier_name")
    private String supplierName; // 分包单位名称
    @TableField(value="vat_mny")
    private BigDecimal vatMny; // 项目自己增值税
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="flag")
    private Integer flag; // 0-未被引用 1-被引用
    
    
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getApplyCode() {
        return applyCode;
    }

    public void setApplyCode(String applyCode) {
        this.applyCode = applyCode;
    }
    public Long getApplyId() {
        return applyId;
    }

    public void setApplyId(Long applyId) {
        this.applyId = applyId;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getProjectBillId() {
        return projectBillId;
    }

    public void setProjectBillId(Long projectBillId) {
        this.projectBillId = projectBillId;
    }
    public Long getBuyerId() {
        return buyerId;
    }

    public void setBuyerId(Long buyerId) {
        this.buyerId = buyerId;
    }
    public String getBuyerName() {
        return buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }
    public Long getProjectAccountingId() {
        return projectAccountingId;
    }

    public void setProjectAccountingId(Long projectAccountingId) {
        this.projectAccountingId = projectAccountingId;
    }
    public String getProjectAccountingName() {
        return projectAccountingName;
    }

    public void setProjectAccountingName(String projectAccountingName) {
        this.projectAccountingName = projectAccountingName;
    }
    public BigDecimal getTaxLevyRate() {
        return taxLevyRate;
    }

    public void setTaxLevyRate(BigDecimal taxLevyRate) {
        this.taxLevyRate = taxLevyRate;
    }
    public Date getActualOpenDate() {
        return actualOpenDate;
    }

    public void setActualOpenDate(Date actualOpenDate) {
        this.actualOpenDate = actualOpenDate;
    }
    public BigDecimal getOpenMny() {
        return openMny;
    }

    public void setOpenMny(BigDecimal openMny) {
        this.openMny = openMny;
    }
    public BigDecimal getShouldReceiveTax() {
        return shouldReceiveTax;
    }

    public void setShouldReceiveTax(BigDecimal shouldReceiveTax) {
        this.shouldReceiveTax = shouldReceiveTax;
    }
    public BigDecimal getPreparementMny() {
        return preparementMny;
    }

    public void setPreparementMny(BigDecimal preparementMny) {
        this.preparementMny = preparementMny;
    }
    public Date getPreparementDate() {
        return preparementDate;
    }

    public void setPreparementDate(Date preparementDate) {
        this.preparementDate = preparementDate;
    }
    public BigDecimal getWaitTaxMny() {
        return waitTaxMny;
    }

    public void setWaitTaxMny(BigDecimal waitTaxMny) {
        this.waitTaxMny = waitTaxMny;
    }
    public Long getContractualModel() {
        return contractualModel;
    }

    public void setContractualModel(Long contractualModel) {
        this.contractualModel = contractualModel;
    }
    public String getContractualModelName() {
        return contractualModelName;
    }

    public void setContractualModelName(String contractualModelName) {
        this.contractualModelName = contractualModelName;
    }
    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }
    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    public Date getDedDate() {
        return dedDate;
    }

    public void setDedDate(Date dedDate) {
        this.dedDate = dedDate;
    }
    public BigDecimal getDedMny() {
        return dedMny;
    }

    public void setDedMny(BigDecimal dedMny) {
        this.dedMny = dedMny;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public BigDecimal getVatMny() {
        return vatMny;
    }

    public void setVatMny(BigDecimal vatMny) {
        this.vatMny = vatMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getFlag() {
        return flag;
    }

    public void setFlag(Integer flag) {
        this.flag = flag;
    }
}
