/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.finance.vo.ReceiveVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/receive"})
public class ReceiveController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IReceiveService receiveService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ReceiveVO> saveOrUpdate(@RequestBody ReceiveVO receiveVO) {
        ReceiveVO backVO = this.receiveService.insertOrUpdate(receiveVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReceiveVO> queryDetail(Long id) {
        ReceiveVO backVO = this.receiveService.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/queryPrint"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("Receive", (Object)this.receiveService.queryDetail(id));
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject page = this.receiveService.queryPageJson(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReceiveVO> vos) {
        List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        String msg = this.receiveService.delete(ids);
        return CommonResponse.success((String)msg);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List<ReceiveVO> supplierVos = this.receiveService.queryExportList(queryParam);
        HashMap<String, List<ReceiveVO>> beans = new HashMap<String, List<ReceiveVO>>();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("receive-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/queryInfoContractId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReceiveVO> queryInfoContractId(Long contractId) {
        ReceiveVO receiveVO = this.receiveService.queryInfoContractId(contractId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)receiveVO);
    }

    @RequestMapping(value={"/queryTotalReceiveMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ReceiveVO>> queryTotalReceiveMny(@RequestParam(value="quoteIds") List<Long> quoteIds) {
        List<ReceiveVO> vos = this.receiveService.queryTotalReceiveMny(quoteIds);
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", vos);
    }

    @RequestMapping(value={"/queryInfoProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ReceiveVO> queryInfoProjectId(Long projectId) {
        ReceiveVO receiveVO = this.receiveService.queryInfoProjectId(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)receiveVO);
    }

    @RequestMapping(value={"/queryReceiveByProjectBillId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryReceiveByProjectBillId(@RequestParam Long projectBillId) {
        JSONObject returnObject = new JSONObject();
        List detailList = this.receiveService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"project_bill_id", (Object)projectBillId)).eq((Object)"receive_kind", (Object)1850783141581557761L));
        returnObject.put("detailList", (Object)detailList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)returnObject);
    }
}

