/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bid.service.impl;

import com.ejianc.business.bid.bean.ProjectRegistrationEntity;
import com.ejianc.business.bid.service.IProjectRegistrationService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectRegistration")
public class ProjectRegistrationBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectRegistrationService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ProjectRegistrationEntity e = (ProjectRegistrationEntity)((Object)this.service.selectById(billId));
        e.setCommitDate(new Date());
        e.setCommitUserCode(InvocationInfoProxy.getUsercode());
        e.setCommitUserCode(this.sessionManager.getUserContext().getUserName());
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u63d0\u4ea4\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.doBack(billId, state, billTypeCode);
    }

    public CommonResponse<String> doBack(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u9879\u76ee\u62a5\u540d\u5355\u636ebillId-{}, state-{}, billTypeCode-{}\u64a4\u56de\u4e8b\u4ef6\u5904\u7406", new Object[]{billId, state, billTypeCode});
        CommonResponse checkCommonResponse = this.billTypeApi.checkQuote(billTypeCode, billId);
        boolean success = checkCommonResponse.isSuccess();
        if (!success) {
            return CommonResponse.error((String)"\u9879\u76ee\u62a5\u540d\u5df2\u53d1\u751f\u4e0b\u6e38\u4e1a\u52a1,\u4e0d\u80fd\u5f03\u5ba1\u548c\u64a4\u56de");
        }
        ProjectRegistrationEntity e = (ProjectRegistrationEntity)((Object)this.service.selectById(billId));
        e.setCommitDate(null);
        e.setCommitUserCode(null);
        e.setCommitUserCode(null);
        e.setEffectiveDate(null);
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u9000\u56de\u8c03\u67e5\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ProjectRegistrationEntity e = (ProjectRegistrationEntity)((Object)this.service.selectById(billId));
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state)) {
            e.setCommitDate(new Date());
            e.setCommitUserCode(InvocationInfoProxy.getUsercode());
            e.setCommitUserCode(this.sessionManager.getUserContext().getUserName());
        }
        e.setEffectiveDate(new Date());
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.doBack(billId, state, billTypeCode);
    }
}

