package com.ejianc.business.bid.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.bid.mapper.BusOpportunityMapper;
import com.ejianc.business.bid.bean.BusOpportunityEntity;
import com.ejianc.business.bid.service.IBusOpportunityService;

import java.util.List;

/**
 * 投标管理-商机登记实体
 * 
 * @author generator
 * 
 */
@Service("busOpportunityService")
public class BusOpportunityServiceImpl extends BaseServiceImpl<BusOpportunityMapper, BusOpportunityEntity> implements IBusOpportunityService{

    @Override
    public List<BusOpportunityEntity> getAllByRegistrationId(Long registrationId, Long id) {
        QueryWrapper<BusOpportunityEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        if(null != registrationId) {
            query.eq("registration_id", registrationId);
        }
        if(null != id) {
            query.ne("id", id);
        }
        return super.list(query);
    }
}
