package com.ejianc.business.finance.controller;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.finance.vo.ReceiveVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@Controller
@RequestMapping("/receive")
public class ReceiveController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IReceiveService receiveService;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IProjectApi projectApi;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 新增或者修改
     * @param receiveVO
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReceiveVO> saveOrUpdate(@RequestBody ReceiveVO receiveVO) {
        ReceiveVO backVO = receiveService.insertOrUpdate(receiveVO);
        return CommonResponse.success("保存或修改单据成功！", backVO);
    }
    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReceiveVO> queryDetail(Long id) {
        ReceiveVO backVO = receiveService.queryDetail(id);
        return CommonResponse.success("查询详情数据成功！", backVO);
    }
    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description queryPrint 查询打印详情
     * @param id
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryPrint", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("Receive", receiveService.queryDetail(id));
        return CommonResponse.success("查询打印数据成功！",json);
    }

    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description saveOrUpdate 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        JSONObject page = receiveService.queryPageJson(param,false);
        return CommonResponse.success("查询列表数据成功！", page);
    }

    /**
     * @Author yqls
     * @Date 2020/5/28
     * @Description delete 批量删除单据
     * @Param [ids]
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ReceiveVO> vos) {
        List<Long> ids = vos.stream().map(ReceiveVO::getId).collect(Collectors.toList());
        String msg = receiveService.delete(ids);
        return CommonResponse.success(msg);
    }


    /**
     * excel导出
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        List<ReceiveVO> supplierVos = receiveService.queryExportList(queryParam);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("receive-export.xlsx", beans, response);
    }

//    /**
//     * 统计累计已生效的收支
//     *
//     * @param projectRange
//     * @return
//     */
//    @GetMapping(value = "/countRecAndPay")
//    @ResponseBody
//    public CommonResponse<JSONObject> countRecAndPay(HttpServletRequest req, @RequestParam(value = "projectRange") Integer projectRange,@RequestParam(required = false) Long engineeringType) {
//        JSONObject resp = new JSONObject();
//        List<Long> projectIds = new ArrayList<>();
//        if(null!=projectRange) {
//            CommonResponse<List<Long>> res = projectApi.getProjectIdsByEngineeringType(projectRange,null==engineeringType?null:engineeringType);
//            if(!res.isSuccess()) {
//                if(!res.isSuccess()) {
//                    logger.error("根据条件 projectRange-{} 查询项目Id列表失败，原因：{}", projectRange, res.getMsg());
//                    return CommonResponse.error("查询失败，查询匹配的项目信息失败。");
//                }
//            }
//            projectIds = res.getData();
//            if(CollectionUtils.isEmpty(projectIds)) {
//                resp.put("rec", 0);
//                resp.put("out", 0);
//                return CommonResponse.success(resp);
//            }
//        }
//        /**
//         * 这个地方的orgIds 使用不到给一个你null
//         * countByProperties 这个接口需要添加移动端组织过滤
//         */
//        List<Long> orgIds = new ArrayList<>();
//        UserContext userContext = sessionManager.getUserContext();
//        String authOrgIds = userContext.getAuthOrgIds();
//        if (StringUtils.isNotEmpty(authOrgIds)) {
//            CommonResponse<List<OrgVO>> authResponse =
//                    orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).
//                            collect(Collectors.toList()));
//            orgIds = authResponse.getData().stream().map(OrgVO::getId).collect(Collectors.toList());
//        }  else {
//            orgIds = orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList());
//        }
//        //收入
//        Map<String, Object> result = receiveService.countRecAmt(InvocationInfoProxy.getTenantid() ,projectIds,orgIds, false);
//        resp.put("rec", result.get("amt"));
//
//        //支出
//        //1、合同付款
//        Map<String, Object> payContractResult = payContractService.countAmt(InvocationInfoProxy.getTenantid(), projectIds);
//        Map<String, Object> paySporadicResult = paySporadicService.countAmt(InvocationInfoProxy.getTenantid(), projectIds);
//        Map<String, Object> payReimburse = payReimburseService.countAmt(InvocationInfoProxy.getTenantid(), projectIds);
//        Map<String, Object> loadReimburseResult = loadReimburseService.countAmt(InvocationInfoProxy.getTenantid(), projectIds);
//        BigDecimal totalOut = new BigDecimal(0);
//        totalOut = totalOut.add(new BigDecimal(payContractResult.get("amt").toString()));
//        totalOut = totalOut.add(new BigDecimal(paySporadicResult.get("amt").toString()));
//        totalOut = totalOut.add(new BigDecimal(payReimburse.get("amt").toString()));
//        totalOut = totalOut.add(new BigDecimal(loadReimburseResult.get("amt").toString()));
//
//        resp.put("out", totalOut.divide(new BigDecimal(10000), 2, BigDecimal.ROUND_HALF_UP));
//        return CommonResponse.success(resp);
//    }
//    /**
//     * @Author jiangyikia
//     * @Date 2022/4/20
//     * @Description saveOrUpdate 查询详情
//     * @param vos
//     * @Return
//     */
//    @RequestMapping(value = "/getLastReceiveTaxMny", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<List<ReceiveQuteDetailVO>> getLastReceiveTaxMny(@RequestBody  List<ReceiveQuteDetailVO> vos) {
//        List<ReceiveQuteDetailVO> list=receiveService.getLastReceiveTaxMny(vos);
//        return CommonResponse.success("查询详情数据成功！", list);
//    }


    /***
     * 根据合同id 查询 合同累计收款
     * @param contractId
     * @return
     */
    @RequestMapping(value = "/queryInfoContractId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReceiveVO> queryInfoContractId(Long contractId) {
        ReceiveVO receiveVO= receiveService.queryInfoContractId(contractId);
        return CommonResponse.success("查询打印数据成功！",receiveVO);
    }

    @RequestMapping(value = "/queryTotalReceiveMny", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ReceiveVO>> queryTotalReceiveMny(@RequestParam(value ="quoteIds") List<Long> quoteIds) {
        List<ReceiveVO> vos= receiveService.queryTotalReceiveMny(quoteIds);
        return CommonResponse.success("查询打印数据成功！",vos);
    }

    /***
     * 根据项目id 查询 合同累计收款
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/queryInfoProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReceiveVO> queryInfoProjectId(Long projectId) {
        ReceiveVO receiveVO= receiveService.queryInfoProjectId(projectId);
        return CommonResponse.success("查询打印数据成功！",receiveVO);
    }


    /**
     * @Description 根据项目id查询单据的数据
     * @param
     * @Return void
     */
    @RequestMapping(value = "/queryReceiveByProjectBillId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> queryReceiveByProjectBillId(@RequestParam Long projectBillId) {
        JSONObject returnObject = new JSONObject();
        List<ReceiveEntity> detailList = receiveService.list(new QueryWrapper<ReceiveEntity>().eq("project_bill_id", projectBillId).eq("receive_kind", 1850783141581557761L));
        returnObject.put("detailList", detailList);
        return CommonResponse.success("查询列表数据成功！", returnObject);
    }
}
