/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.contract.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contract.bean.ContractManageEntity;
import com.ejianc.business.contract.bean.ContractRecordEntity;
import com.ejianc.business.contract.service.IContractManageService;
import com.ejianc.business.contract.service.IContractRecordService;
import com.ejianc.business.contract.utils.BillCodeSetEnum;
import com.ejianc.business.contract.vo.ContractManageVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"contractManage"})
public class ContractManageController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IContractManageService service;
    @Autowired
    private IContractRecordService recordService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ContractManageVO> saveOrUpdate(@RequestBody ContractManageVO saveOrUpdateVO) {
        ContractManageEntity entity = (ContractManageEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ContractManageEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BillCodeSetEnum.getEnumByContractType(entity.getContractType()).getBillCode(), (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        ContractManageVO vo = this.service.saveContract(entity);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryRecordDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractManageVO> queryRecordDetail(Long id) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ContractRecordEntity::getChangeId, (Object)id);
        ContractRecordEntity contractEntity1 = (ContractRecordEntity)((Object)this.recordService.getOne((Wrapper)lambda));
        ContractRecordEntity contractEntity = (ContractRecordEntity)((Object)this.recordService.selectById(contractEntity1.getId()));
        ContractManageVO contractVO = (ContractManageVO)BeanMapper.map((Object)((Object)contractEntity), ContractManageVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)contractVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ContractManageVO> queryDetail(Long id) {
        ContractManageEntity entity = (ContractManageEntity)((Object)this.service.selectById(id));
        ContractManageVO vo = (ContractManageVO)BeanMapper.map((Object)((Object)entity), ContractManageVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/querConByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<ContractManageVO>> querConByProjectId(Long projectId) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(ContractManageEntity::getProjectId, (Object)projectId)).eq(BaseEntity::getDr, (Object)0)).in(ContractManageEntity::getBillState, new Object[]{1, 3})).orderByDesc(BaseEntity::getCreateTime);
        List list = this.service.list((Wrapper)lambdaQueryWrapper);
        List vo = BeanMapper.mapList((Iterable)list, ContractManageVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryTotalConMnyBySupplierId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> queryTotalConMnyBySupplierId(Long supplierId) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(ContractManageEntity::getSupplierId, (Object)supplierId)).eq(BaseEntity::getDr, (Object)0)).in(ContractManageEntity::getBillState, new Object[]{1, 3});
        List list = this.service.list((Wrapper)lambdaQueryWrapper);
        BigDecimal sumConMny = list.stream().map(ContractManageEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)sumConMny);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ContractManageVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ContractManageVO contractManageVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getComplexParams().add(this.getPageQueryParam(null));
        IPage pageData = this.service.queryPage(param, false);
        Map<String, Object> contractAmountMap = this.service.countContractAmount(param);
        JSONObject page = new JSONObject();
        page.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), ContractManageVO.class));
        page.put("total", (Object)pageData.getTotal());
        page.put("current", (Object)pageData.getCurrent());
        page.put("size", (Object)pageData.getSize());
        page.put("pages", (Object)pageData.getPages());
        page.put("sumMnyMap", contractAmountMap);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getComplexParams().add(this.getPageQueryParam(null));
        List entityList = this.service.queryList(param);
        List list = BeanMapper.mapList((Iterable)entityList, ContractManageVO.class);
        list.forEach(vo -> {
            if (null != vo.getContractStatus()) {
                if ("1".equals(vo.getContractStatus())) {
                    vo.setContractStatusName("\u672a\u7b7e\u8ba2");
                } else if ("2".equals(vo.getContractStatus())) {
                    vo.setContractStatusName("\u5c65\u7ea6\u4e2d");
                } else if ("3".equals(vo.getContractStatus())) {
                    vo.setContractStatusName("\u5df2\u5c01\u8d26");
                }
            } else {
                vo.setContractStatusName("");
            }
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().exportWithTrans("ContractManage-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refContractManageData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ContractManageVO>> refContractManageData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("employeeName");
        ArrayList<Integer> billStateList = new ArrayList<Integer>();
        billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter("in", billStateList));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractStatus", new Parameter("ne", (Object)3));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("projectType")) {
                Integer projectType = Integer.valueOf(conditionMap.get("projectType").toString());
                param.getParams().put("projectType", new Parameter("eq", (Object)projectType));
            }
            if (null != conditionMap.get("contractType")) {
                Integer contractType = Integer.valueOf(conditionMap.get("contractType").toString());
                param.getParams().put("contractType", new Parameter("eq", (Object)contractType));
            }
        }
        param.getComplexParams().add(this.getPageQueryParam(null));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ContractManageVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    public ComplexParam getPageQueryParam(Long orgId) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        if (null == orgId) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        CommonResponse childOrgResp = this.iOrgApi.findChildrenByParentId(orgId);
        CommonResponse parentOrgResp = this.iOrgApi.findParentsByOrgId(orgId);
        if (!childOrgResp.isSuccess() || !parentOrgResp.isSuccess()) {
            throw new BusinessException("\u5408\u540c\u5206\u9875\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        ArrayList parentOrgIds = new ArrayList();
        ArrayList childIds = new ArrayList();
        childIds.addAll(((List)childOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        parentOrgIds.addAll(((List)parentOrgResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        parentOrgIds.remove(orgId);
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("org_id", new Parameter("in", childIds));
        c1.getComplexParams().add(c2);
        if (CollectionUtils.isNotEmpty(parentOrgIds)) {
            ComplexParam c3 = new ComplexParam();
            c3.setLogic("or");
            c3.getParams().put("project_type", new Parameter("eq", (Object)2));
            c3.getParams().put("org_id", new Parameter("in", parentOrgIds));
            c3.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
            c1.getComplexParams().add(c3);
        }
        return c1;
    }
}

