package com.ejianc.business.project.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.project.mapper.ProjectRegisterMapper;
import com.ejianc.business.project.bean.ProjectRegisterEntity;
import com.ejianc.business.project.service.IProjectRegisterService;

import java.util.List;

/**
 * 项目基本信息管理-项目立项
 * 
 * @author generator
 * 
 */
@Service("projectRegisterService")
public class ProjectRegisterServiceImpl extends BaseServiceImpl<ProjectRegisterMapper, ProjectRegisterEntity> implements IProjectRegisterService{

    @Override
    public ProjectRegisterEntity getByAffirmId(Long affirmId) {
        QueryWrapper<ProjectRegisterEntity> query = new QueryWrapper<>();
        query.eq("affirm_id", affirmId);

        return super.getOne(query);
    }

    @Override
    public List<ProjectRegisterEntity> getAllByOrgIds(List<Long> orgIds, String projectStatus) {
        QueryWrapper<ProjectRegisterEntity> query = new QueryWrapper<>();
        query.in("org_id", orgIds);
        if(StringUtils.isNotBlank(projectStatus)) {
            query.in("status", projectStatus.split(","));
        }

        return super.list(query);
    }

    @Override
    public List<ProjectRegisterEntity> getAllByDepartmentIds(List<Long> departmentIds, String projectStatus) {
        QueryWrapper<ProjectRegisterEntity> query = new QueryWrapper<>();
        query.in("project_department_id", departmentIds);
        if(StringUtils.isNotBlank(projectStatus)) {
            query.in("status", projectStatus.split(","));
        }

        return super.list(query);
    }
}
